
code16seg segment

raw_init proc
;alloc memory from INT 15h
  mov ah,88h
  int 15h      ;get total XMS 1k blocks free
  cmp ax,xms_min
  jae r1
  mov dx,offset msg_xms_low
  jmp exit16error
r1:   ;ok there is enough RAM
  mov cx,ax
  sub ax,xms_max
  jnc r2
  mov ax,0    ;leave no memory
r2:
  mov xms_left,ax
  sub cx,ax          ;size of our XMS RAM
  xor ebx,ebx
  mov bx,ax
  mov eax,1024*1024  ;1MB
  shl ebx,10         ;*1k
  add eax,ebx        ;eax = 1MB + XMS_left * 1k  => XMS_base
  mov xms_base,eax
  xor eax,eax
  mov ax,cx
  shl eax,10         ;*1k
  mov xms_size,eax   ;eax = # of 1k blocks * 1k => XMS_size

;Install our own int 15h handler
  mov ax,3515h
  int 21h            ;get int 15h
  mov wptr[old_int15h+2],es
  mov wptr[old_int15h+0],bx
  push ds
  pop es

  mov ax,2515h
  mov dx,offset int15h
  int 21h            ;set int 15h

;enable the a20 so we can access RAM above 1MB.
  call enablea20
  cmp ax,ERROR
  jnz r3
  mov dx,offset msg_a20
  jmp exit16error
r3:
  ret
raw_init endp

raw_uninit proc
  mov eax,old_int15h                   ;INT 15h clean-up
  mov es:[15h*4],eax                   ;restore old INT 15h handler
  ret
raw_uninit endp

code16seg ends

