
data16seg segment

xms_base dd ?    ;the start of our XMS RAM we have alloc
xms_size dd ?    ;the size of our XMS RAM
xms_call dd ?    ;seg:off to call XMS driver
xms_emb dw ?     ;our EMB handle alloc'ed from XMS

data16seg ends

code16seg segment

xms_detect proc
  mov ax,4300h
  int 2fh
  cmp al,80h
  .if al==80h
    mov al,1
    ret
  .endif
  xor al,al
  ret
xms_detect endp

XMS_init proc
  mov mode,MODE_XMS
;call a non-desctructive DOS func (to avoid bugs in some XMS drivers)
  mov ah,2ch
  int 21h                              ; get time (but this is ignored)
  mov ax,4310h
  int 2fh                              ; get XMS entry-point
  mov wptr [xms_call+2],es
  mov wptr [xms_call],bx
  push cs                              ;-+
  pop es                               ;restore ES

;enable A20 thru XMS driver
  mov ah,3
  call [xms_call]                      ; global enable A20
  cmp ax,1
  jz x1
  mov dx,offset msg_a20
  jmp exit16error
x1:
  mov ah,8
  call [xms_call]                      ; query free extended memory
  ;ax=RAM free (1k blocks)  (max=64 MBs)
  cmp ax,xms_min
  jae x2
xe1:
  mov dx,offset msg_xms_low
  jmp exit16error
x2:
  cmp ax,xms_max
  jb x3
  mov ax,xms_max
x3:
  xor edx,edx
  mov dx,ax
  shl edx,10                           ;-+   ;*1k
  mov xms_size,edx                     ; |
  shr edx,10                           ;find total size of block
  mov ah,9
  call [xms_call]                      ; alloc EMB
  cmp ax,1
  jnz xe1
  mov xms_emb,dx
  mov ah,0ch
  call [xms_call]                      ; lock EMB
  cmp ax,1
  jz x4
  mov dx,xms_emb
  mov ah,0ah
  call [xms_call]                      ; free EMB
  mov dx,offset msg_xms_lock
  jmp exit16error
x4:
  shl edx,16
  mov dx,bx
  mov xms_base,edx
  ret
xms_init endp

xms_uninit proc
  mov ah,0dh
  mov dx,xms_emb
  call [xms_call]                      ; unlock RAM
  mov ah,0ah
  mov dx,xms_emb
  call [xms_call]                      ; free RAM used
  ret
xms_uninit endp

code16seg ends

