data16seg segment

msg_a20 db 'Unable to enable A20!',13,10,'$'

int15h_left dw ?    ;int 15h will report this much is free
int15h_old dd ?     ;old rmode int 15h handler

old_sp dw ?              ;used by 30xh DPMI funcs

int3vector dd offset ints+3
           dw selcode16

;define our intrmatrix
ints db 256 dup (0cch)                 ;this is what each of the default
                                       ;INT descriptors pts to
                                       ;0cch = int 3 (one-byte opcode)
                                       ;so ALL INTs goto the INT 3 handler
                                       ;which will direct the INT to rmode

;define other variables needed
irq_table dw offset irq0
          dw offset irq1
          dw offset irq2
          dw offset irq3
          dw offset irq4
          dw offset irq5
          dw offset irq6
          dw offset irq7
          dw offset irq8
          dw offset irq9
          dw offset irqa
          dw offset irqb
          dw offset irqc
          dw offset irqd
          dw offset irqe
          dw offset irqf

old_irqs dd 16 dup (?)   ;old rmode IRQ handlers
irqset dw 0              ;each bit is set if an IRQ handler is setup in PMODE
                         ;for that IRQ

data16seg ends

code16seg segment

raw_init proc
;determine if we are in V86 mode (if yes then most likely EMM386,QEMM or
; Windoze is loaded so we can not continue)  Although the VM bit is not
; always detectable (QEMMv8.0) so for now it just crashes (oh well) this
; will support them soon anyways
  smsw ax                         ; AX = machine status word
  test al,1                       ; is system in protected mode?
  jz ok_v86                       ; if not in protected mode then cont
  mov dx,offset msg_v86
  jmp exit16error
ok_v86:
;alloc memory from INT 15h
  mov ah,88h
  int 15h      ;get total extended 1k blocks free
  mov cx,ax
  mov ebx,ram_max
  shr ebx,10   ;convert bytes to Ks
  .if ebx>=64*1024   ;64MBs?
    xor ax,ax
  .else
    sub ax,bx
    .if carry?
      xor ax,ax    ;leave no memory
    .endif
  .endif
  mov int15h_left,ax
  sub cx,ax          ;size of our XMS RAM
  xor ebx,ebx
  mov bx,ax
  mov eax,1024*1024  ;1MB
  shl ebx,10         ;*1k
  add eax,ebx        ;eax = 1MB + int15h_left * 1k  => XMS_base
  mov xms_base,eax
  xor eax,eax
  mov ax,cx
  shl eax,10         ;*1k
  mov xms_size,eax   ;eax = # of 1k blocks * 1k => XMS_size

;Install our own int 15h handler
  mov ax,3515h
  int 21h            ;get int 15h
  mov wptr[int15h_old+2],es
  mov wptr[int15h_old+0],bx
  push ds
  pop es

  mov ah,25h
  mov dx,offset int15h
  int 21h            ;set int 15h

  mov inited,1       ;after this point raw_uninit should be called on fatal
                     ;errors

;enable the a20 so we can access RAM above 1MB.
  call enablea20
  cmp ax,ERROR
  jnz r3
  mov dx,offset msg_a20
  jmp exit16error
r3:
  ret
raw_init endp

raw_uninit proc
; in : ds=segs16  es=0
  mov eax,int15h_old                   ;INT 15h clean-up
  mov es:[15h*4],eax                   ;restore old INT 15h handler
  ret
raw_uninit endp

int15h proc                       ; this is the new INT 15h handler
  cmp ah,88h                      ;It will report how much RAM if free minus
  jnz chain_int15h                ;what we have taken
  mov ax,cs:int15h_left
  iret
chain_int15h:
  jmp cs:[int15h_old]
int15h endp

;this next PROC will enable the A20 Gate so we can access RAM above 1 MB
enablea20 proc                    ; hardware enable gate A20
  pushf
  push fs
  push gs
  cli

  xor ax,ax                       ; set A20 test segments 0 and 0ffffh
  mov fs,ax
  dec ax
  mov gs,ax

  call enablea20test              ; is A20 already enabled?
  jz short enablea20done          ; if yes, done

  in al,92h                       ; PS/2 A20 enable
  or al,2
  jmp short $+2
  jmp short $+2
  jmp short $+2
  out 92h,al

  call enablea20test              ; is A20 enabled?
  jz short enablea20done          ; if yes, done

  call enablea20kbwait            ; AT A20 enable
  jnz short enablea20f0

  mov al,0d1h
  out 64h,al

  call enablea20kbwait
  jnz short enablea20f0

  mov al,0dfh
  out 60h,al

  call enablea20kbwait

enablea20f0:                      ; wait for A20 to enable
  mov cx,800h                     ; do 800h tries

enablea20l0:
  call enablea20test              ; is A20 enabled?
  jz enablea20done                ; if yes, done

  in al,40h                       ; get current tick counter
  jmp short $+2
  jmp short $+2
  jmp short $+2
  in al,40h
  mov ah,al

enablea20l1:                      ; wait a single tick
  in al,40h
  jmp short $+2
  jmp short $+2
  jmp short $+2
  in al,40h
  cmp al,ah
  je enablea20l1

  dec cx
  jnz enablea20l0                 ; loop for another try

  mov ax,ERROR                    ; error, A20 did not enable
  ret

enablea20done:
  pop gs
  pop fs
  popf
  xor ax,ax
  ret

enablea20kbwait:                  ; wait for safe to write to 8042
  xor cx,cx
enablea20kbwaitl0:
  jmp short $+2
  jmp short $+2
  jmp short $+2
  in al,64h                       ; read 8042 status
  test al,2                       ; buffer full?
  loopnz enablea20kbwaitl0        ; if yes, loop
  ret

enablea20test:                    ; test for enabled A20
  mov al,fs:[0]                   ; get byte from 0:0
  mov ah,al                       ; preserve old byte
  not al                          ; modify byte
  xchg al,gs:[10h]                ; put modified byte to 0ffffh:10h
  cmp ah,fs:[0]                   ; set zero if byte at 0:0 not modified
  mov gs:[10h],al                 ; put back old byte at 0ffffh:10h
  ret                             ; return, zero if A20 enabled
enablea20 endp

;-----------------------------------------------------------------------------
; pm 2 rm & rm 2 pm   switching proc for RAW/XMS
; save/restore procs

pm_2_rm_rx proc  ;switches to Rmode  (raw/xms)

;  AX = new DS
;  CX = new ES
;  DX = new SS
;  BX = new SP
;  SI = new CS
;  DI = new IP
; EBP = preserved

  push ax   ;save AX
  mov ds,cs:_selzero32
  xor eax,eax
  mov ax,dx
  shl eax,4
  movzx ebx,bx     ;can't remove this movzx
  add eax,ebx
  pushf
  cli
  pop ds:[eax-2]
  mov ds:[eax-4],si
  mov ds:[eax-6],di
  pop di    ;pop ax into di
  lidt cs:rm_idtr
  mov ax,seldata16
  mov ds,ax
  mov es,ax
  mov fs,ax
  mov gs,ax
  mov ss,ax
  sub ebx,6   ;make room for iret data
  mov esp,ebx
  mov eax,cr0
  and al,0feh
  mov cr0,eax     ;now in rmode
  db 0eah
  dw $+4,segs16
  mov ss,dx
  mov ds,di       ;ax was poped into di
  mov es,cx
  xor ax,ax
  mov fs,ax
  mov gs,ax
  iret            ;goto target addr in real mode
pm_2_rm_rx endp

rm_2_pm_rx proc   ;switches to Pmode from Rmode

;  AX  = new DS
;  CX  = new ES
;  DX  = new SS
;  EBX = new ESP
;  SI  = new CS
;  EDI = new EIP
;  EBP = preserved

  pushfd
  cli
  push ax
  lgdt cs:gdtr
  lidt cs:idtr
  mov eax,cr0
  or al,1
  mov cr0,eax
  db 0eah
  dw $+4,selcode16
  pop ds
  mov es,cx
  xor ax,ax
  mov fs,ax
  mov gs,ax
  pop eax
  mov ss,dx                       ; load protected mode SS:ESP
  mov esp,ebx
  and ah,0bfh                     ; set NT=0 in old EFLAGS
  push ax                         ; set current FLAGS
  popf
  push eax                        ; store old EFLAGS
  push esi                        ; store protected mode target CS
  push edi                        ; store protected mode target EIP
  iretd                           ; go to targed addx in protected mode
rm_2_pm_rx endp

sr_state_pm_rx:
  db 66h     ;32bit retf
sr_state_rm_rx:
  retf   ;nothing to save/restore


init_rxv proc  ;final init for Raw/XMS/Vcpi
;setup all our descriptors
  mov eax,prg_base16
  mov code16.base_lo,ax
  mov data16.base_lo,ax
  shr eax,16
  mov code16.base_mid,al
  mov data16.base_mid,al
;  mov code16.base_hi,ah               ;not needed since AH will always be 0
;  mov data16.base_hi,ah               ; "

  mov eax,prg_base32
  mov code32.base_lo,ax
  mov data32.base_lo,ax
  shr eax,16
  mov code32.base_mid,al
  mov data32.base_mid,al
;  mov code32.base_hi,ah               ; "
;  mov data32.base_hi,ah               ; "

;setup GDT and IDT base
  mov eax,prg_base16
  add eax,gdt_start
  mov gdt_addr,eax
  mov eax,prg_base16
  add eax,idt_start
  mov idt_addr,eax

;setup pm_2_rm stacks
  mov ax,pm2rm_stks
  mul pm2rm_stklen
  mov cx,ax
  call getRAM
  mov pm2rm_stkend,bx
  add bx,cx
  mov pm2rm_stkcur,bx

;setup rm_2_pm stacks
  mov ax,rm2pm_stks
  mul wptr[rm2pm_stklen]
  shl rm2pm_stklen,4        ;NOTE : These must be converted to linear !!!
  mov cx,ax
  call getRAM
  mov wptr[rm2pm_stkend],bx
  shl rm2pm_stkend,4        ;convert to linear
  add bx,cx
  mov wptr[rm2pm_stkcur],bx
  shl rm2pm_stkcur,4        ;convert to linear

;alloc ram for CALLBACKs
  mov cl,callbacks
  or cl,cl
  jz cb2                               ; no callbacks?
  xor ch,ch
  mov ax,25                            ; 25 bytes for each callback
  mul cx
  .if ax & 0fh
    add ax,16
  .endif
  shr ax,4
  call getRAM
  mov callbackseg,bx
  mov wptr callbackbase,bx
  shl callbackbase,4
;setup the CALLBACKs
  mov cl,callbacks
  mov ds,callbackseg
  xor di,di
cb1:
  mov word ptr [di],6066h              ; PUSHAD instruction
  mov byte ptr [di+2],068h             ; PUSH WORD instruction
  mov word ptr [di+3],0                ; immediate 0 used as free flag
  mov word ptr [di+5],06866h           ; PUSH DWORD instruction
  mov byte ptr [di+11],0b9h            ; MOV CX,? instruction
  mov word ptr [di+14],06866h          ; PUSH DWORD instruction
  mov byte ptr [di+20],0eah            ; JMP FAR PTR ?:? intruction
  mov word ptr [di+21],offset callback
  mov word ptr [di+23],segs16
  add di,25                            ; increment ptr to next callback
  dec cl                               ; decrement loop counter
  jnz cb1                              ; if more callbacks to do, loop
  push cs
  pop ds
cb2:
;setup IDT
  mov di,offset idt
  mov si,offset ints
  xor cx,cx
i1:
  mov [di],si
  add di,8
  inc si
  inc cl
  jnz i1
;setup other INTs
  mov wptr[idt+3*8],offset int3h
  mov wptr[idt+31h*8],offset int31h
  mov wptr[idt+21h*8],offset int21h
  ret
init_rxv endp

irq_init proc                          ;setup our rmode IRQ 2 PMODE redir's
  xor bx,bx
  mov bl,picmaster
  shl bx,2
  xor dx,dx
  mov dl,picslave
  shl dx,2

  xor ax,ax
  mov ds,ax
  mov si,bx  ;picmaster
  mov di,offset old_irqs
  mov cx,8
  rep movsd
  mov si,dx  ;picslave
  mov cx,8
  rep movsd

  push es                              ;-+
  push ds                              ; |
  pop es                               ; |
  pop ds                               ;swap DS and ES
  mov si,offset irq_table
  mov ax,segs16
  mov di,bx  ;picmaster
  mov cl,8
rd1:
  movsw
  stosw
  dec cl
  jnz rd1
  mov di,dx  ;picslave
  mov cl,8
rd2:
  movsw
  stosw
  dec cl
  jnz rd2

  push ds    ;-+
  pop es     ;reset ES
  ret
irq_init endp

irq_uninit proc
;restore all RMODE IRQs
; in : ds=segs16 es=0
  xor bx,bx
  mov bl,picmaster
  shl bx,2
  xor dx,dx
  mov dl,picslave
  shl dx,2
  mov di,bx  ;picmaster
  mov si,offset old_irqs
  mov cx,8
  rep movsd
  mov di,dx  ;picslave
  mov cx,8
  rep movsd
  ret
irq_uninit endp

;this proc was copied almost directly from PMODE v3.07 - why reinvent the
;wheel?
int3h proc ;pmode
  ;this will redir INTs (and IRQs) to rmode
  cmp dptr[esp],offset ints            ;I added these extra checks in case
  jb do3                               ;this kernel is debugged later
  cmp dptr[esp],offset ints+255
  ja do3
  cmp wptr[esp+4],selcode16            ;was it from our ints table or is it
  jz redir                             ; an embedded int 3?
;continue on to normal INT 3 handler
do3:
  jmp fptr cs:int3vector               ; JMP FAR sel:off32 handler
;redirect to proper handler in rmode
redir:
  mov [esp+8],eax                      ; store EAX for later POPAD
  mov eax,[esp]                        ; get address in redirection matrix
  add esp,8                            ; discard EIP and CS from INT 3
  push ecx                             ;-+
  push edx                             ; |
  push ebx                             ; |
  push esp                             ; | (ignored by CPU)
  push ebp                             ; |
  push esi                             ; |
  push edi                             ;store rest of registers for POPAD
  push ds                              ;-+
  push es                              ; |
  push fs                              ; |
  push gs                              ;store all segment registers

  mov ds,cs:_selzero32                 ; DS -> 0 (beginning of memory)
  mov edi,cs:prg_base16                ; EDI = offset of SEGS16 from 0

  mov dx,cs:pm2rm_stkcur               ; DX = SS for real mode redirection
  xor ebp,ebp                          ;-+
  mov bp,dx                            ; |
  shl ebp,4                            ; EBP -> top of real mode stack

  cmp dx,cs:pm2rm_stkend               ; exceeded real mode stack space?
  jz critical_error                    ; if yes, critical error (hang)

  mov bx,cs:pm2rm_stklen               ; get size of real mode stack
  sub dx,bx                            ; adjust DX to next stack location
  sub ds:pm2rm_stkcur[edi],bx          ; update ptr for possible reenterancy
  shl bx,4                             ; set real mode SP to top of stack

  mov ds:[ebp-2],ss                    ; store SS:ESP on real mode stack
  mov ds:[ebp-6],esp

  sub ax,offset ints+1                 ; AX = int number
                                       ; the +1 is because the next instruct
                                       ; to return to is after the one-byte
                                       ; int 3 opcode
  mov ah,al                            ;-+
  and ah,0f8h                          ; AH = high 5 bits of int number

  cmp ah,cs:picmaster                  ; low IRQ?
  jz redir_irq                         ; if yes, do IRQ
  cmp ah,cs:picslave                   ; high IRQ?
  jnz redir_int                        ; if no, do INT (with general regs)
  add al,8                             ; upper 8 IRQs
;-----------------------------------------------------------------------------
redir_irq:                             ; an IRQ redirection
  mov si,segs16                        ; real mode target CS:IP
  mov di,offset r1       
  sub bx,6                             ; adjust real mode SP for stored vars
  sub al,ah                            ; convert INT # to IRQ #
  xor ah,ah
  shl ax,2
  mov bp,offset old_irqs
  add bp,ax
  mov ax,segs16                        ; rmode DS

  db 66h                               ; JMP DWORD PTR, as in 32bit offset,
  jmp wptr cs:pm_2_rm                  ;  not seg:16bit offset

r1:
  pushf
  push cs
  push offset r1b
  push dptr ds:[bp]
  retf
r1b:
  mov ax,seldata16                     ; DS selector value for protected mode
  mov cx,ax                            ; ES selector value for protected mode
  pop ebx                              ; get protected mode SS:ESP from stack
  pop dx
  mov si,selcode16                     ; target CS:EIP in protected mode
  mov edi,offset r2

  jmp cs:rm_2_pm                       ; go back to protected mode

r2:
  mov ax,pm2rm_stklen                  ; release real mode stack
  add pm2rm_stkcur,ax

  pop gs                               ;-+
  pop fs                               ; |
  pop es                               ; |
  pop ds                               ; |
  popad                                ;restore all registers
  iretd

;-----------------------------------------------------------------------------
redir_int:                             ; an INT redirection
  mov ds:intnum[edi],al                ; modify code with interrupt number

  mov es,cs:_selzero32                 ; copy registers from protected mode
  lea edi,[ebp-26h]                    ;  stack to real mode stack
  lea esi,[esp+8]                      ; esp+8 => popad
  mov ecx,8
  cld
  rep movsd es:[edi],ss:[esi]          ; note the SS override!

  mov si,segs16                        ; real mode target CS:IP
  mov di,offset i1
  sub bx,26h                           ; adjust real mode SP for stored vars

  db 66h                               ; JMP DWORD PTR, as in 32bit offset,
  jmp wptr cs:pm_2_rm                  ;  not seg:16bit offset

i1:
  popad                                ; load regs with int call values

  db 0cdh                              ; INT intnum
intnum db ?

  pushad                               ; store registers on stack
  pushf                                ; store flags on stack
  cli
  cld

  xor eax,eax                          ; EAX = linear ptr to SS
  mov ax,ss
  shl eax,4
  xor ebp,ebp                          ;-+
  mov bp,sp                            ; EBP = SP

  mov ebx,[bp+22h]                     ; get protected mode SS:ESP from stack
  mov dx,[bp+26h]

  add ebp,eax                          ; EBP -> stored regs on stack

  mov ax,selzero32                     ; DS selector value for pmode zero32
  mov cx,dx                            ; ES selector value for pmode stack
  mov si,selcode16                     ; target CS:EIP in protected mode
  mov edi,offset i2

  jmp cs:rm_2_pm                       ; go back to protected mode

i2:
  mov ax,ds:[ebp]                      ; move return FLAGS from real mode
  and ax,8d5h                          ;  stack to protected mode stack
  mov bx,[esp+30h]                     ; get flags from stack
  and bx,not 8d5h
  or ax,bx                             ; merge pmode/rmode flags
  mov [esp+30h],ax                     ; put flags onto IRETD

  lea esi,[ebp+2]                      ;DS:ESI => rmode pushad
  lea edi,[esp+8]                      ;ES:EDI => pmode popad
  mov ecx,8
  db 67h                               ;-+
  rep movsd                            ; copy from rmode stack to pmode stack

  mov edi,cs:prg_base16                ; release  real mode stack
  mov ax,cs:pm2rm_stklen
  add ds:pm2rm_stkcur[edi],ax

  pop gs                               ;-+
  pop fs                               ; |
  pop es                               ; |
  pop ds                               ; |
  popad                                ; restore all regs
  iretd
int3h endp

;-----------------------------------------------------------------------------
;int 31h funcs 300h,301h,302h
_300h proc
  ;300h = simulate rmode INT
  ;301h = call CS:IP with RETF stack frame
  ;302h = call CS:IP with IRET stack frame
  ; in : ES:(E)DI => callstruct
  ;    : BH = 0
  ;    : BL = int # (if 300h)
  ;    : CX = # words to copy to stack
  ; out: ES:(E)DI => updated callstruct

;if you are going to trace this code I suggest you grab paper and put the
;rmode and pmode stacks on it and create them as you look thru this

  std                                  ;copy backwards
  pushad
  mov ebp,esp
  add ebp,11*4                         ;ebp -> stack params (pushad:EIP:CS:flags)
  push ds
  push es
  push fs
  push gs

  mov ds,cs:_seldata16
  mov ebx,edi
  cmp dptr es:[edi].callstruct._sp,0
  jz s1
;get SS:SP from callstruct
  xor eax,eax
  mov ax,es:[edi].callstruct._ss
  push ax                              ;save for later (rmode SS)
  shl eax,4
  xor edx,edx
  mov dx,es:[edi].callstruct._sp
  push dx                              ;save for later (rmode SP)
  add eax,edx
  jmp c1                               ; EAX = rmode TOS, DX = SP
s1:  ;supply system stack
  xor eax,eax
  mov ax,pm2rm_stkcur                  ;get next stack location
  cmp ax,pm2rm_stkend                  ;check if a stack is avail.
  jnz ok1
  jmp int31hfail
ok1:
  mov dx,pm2rm_stklen                  ;make stack pt to next location
  sub ax,dx
  sub pm2rm_stkcur,dx
  push ax                              ;save for later (rmode SS)
  add ax,dx
  shl eax,4
  shl dx,4                             ; EAX = rmode TOS, DX = SP
  push dx                              ;save for later (rmode SP)
c1:
;preserve current rmode stack ptr (SP) (so it will be easy to pop off
; parms from rmode stack later)
  sub dx,6                             ;reserve space for SS:ESP on rmode stk
  xchg dx,old_sp
  push dx                              ;preserve old_sp
;prepare rmode stack ptr
  push es                              ;preserve ES
  mov es,_selzero32                    ;-+
  mov edi,eax                          ;es:edi => dest stack
;copy SS:ESP onto rmode stack so they can be restored later on
  sub edi,2
  mov es:[edi],ss
  sub edi,4
  lea eax,[esp+2]
  db 67h
  stosd
  add edi,2
;check if there are any stack params
  or cx,cx
  jz c2
;prepare pmode stack ptr
  push ss                              ;-+
  pop ds                               ; |
  mov esi,ebp                          ;ds:esi => src stack
;copy over CX words from current stack to new stack (params)
  xor edx,edx
  mov dx,cx
  mov ecx,edx                          ;clear high word of ecx
  dec dx
  shl edx,1
  add esi,edx
  db 67h                               ;-+
  rep movsw                            ;copy stack over
  add esi,2                            ;move back to normal pos
;copy (maybe Flags):CS:IP to rmode stack (used to return back to pmode)
c2:
  cmp bptr[ebp-11*4].callstruct._eax,1
  jz f4
  pushf
  pop ax
  db 67h
  stosw
f4:
  mov ax,segs16
  db 67h
  stosw 
  mov ax,offset r2
  db 67h
  stosw
;copy Flags:CS:IP to call rmode int/proc
  pop ds                               ;restore ES into DS
  mov ax,[ebx].callstruct._flg         ;flags from callstruct
  cmp bptr[ebp-11*4].callstruct._eax,1
  jz f1
  and ah,0fch                          ;clear IF and TF for func 300h,302h
f1:
  db 67h
  stosw                                ;save flags on rmode stack
  cmp bptr[ebp-11*4].callstruct._eax,0
  jnz f2
;300h
  xor eax,eax
  mov al,bptr[ebp-11*4].callstruct._ebx
  shl eax,2  ;*4
  mov eax,es:[eax]                     ;get rmode INT # CS:IP
  jmp f3
f2:
;301h and 302h
  mov eax,dptr[ebx].callstruct._ip
f3:
  sub edi,2
  db 67h
  stosd
  add edi,2
;copy FS and GS for real mode
  mov ax,[ebx].callstruct._gs
  db 67h
  stosw
  mov ax,[ebx].callstruct._fs
  db 67h
  stosw
;copy over callstruct (only what is needed)
  sub edi,2
  mov ecx,8                            ;8 dwords to copy
  mov esi,ebx                          ;ds:esi => callstruct
  add esi,7*4                          ;start from bottom of block
  db 67h                               ;-+
  rep movsd                            ;copy callstruct over
  add esi,4                            ;ds:esi => callstruct
  add edi,4                            ;es:edi => rmode tos

;  AX = new DS
;  CX = new ES
;  DX = new SS
;  BX = new SP
;  SI = new CS
;  DI = new IP

  xor eax,eax
  mov dx,[esp+4]                       ;SS
  mov ax,dx
  shl eax,4
  sub edi,eax
  mov bx,di                            ;SP

  mov ax,[esi].callstruct._ds          ;DS
  mov cx,[esi].callstruct._es          ;ES
  mov si,segs16                        ;CS
  mov di,offset r1                     ;IP

  db 66h                               ;-+
  jmp wptr cs:pm_2_rm                  ;jmp DWORD PTR  (32bit offset)

r1:

  popad
  pop fs
  pop gs

  iret

r2:    ;return back to PMODE
;remove stack parameters
  mov sp,cs:old_sp
  push gs                              ;order preserved is important
  push fs
  push ds
  push es
  pushf
  pushad

  mov bp,sp
  mov ebx,[bp+42]                      ;for ESP
  mov dx,[bp+46]                       ;for SS
  mov si,selcode16
  mov ax,selzero32
  mov cx,ax
  mov edi,offset p1

;  AX  = new DS
;  CX  = new ES
;  DX  = new SS
;  EBX = new ESP
;  SI  = new CS
;  EDI = new EIP

  jmp cs:rm_2_pm

p1:
  mov ebx,cs:prg_base16
  pop ds:old_sp[ebx]

  mov edi,[esp+6*2].callstruct._edi  ;get saved EDI
  mov es,[esp+4*2]                   ;get saved ES

;copy rmode stack to callstruct
  xor eax,eax
  pop ax                               ;pop rmode SP
  xor esi,esi
  pop si                               ;pop rmode SS
  shl esi,4
  add esi,eax
  sub esi,42+6                         ;move back to saved regs on rmode stack
  mov ecx,10
  cld
  mov eax,es:[edi].callstruct._res     ;this must be reserved
  mov [esi].callstruct._res,eax
  db 67h
  rep movsd
  db 67h                               ;copy last word
  movsw
;release system stack
  cmp dptr es:[edi].callstruct._sp,0
  jz p4
  mov ax,ds:pm2rm_stklen[ebx]
  add ds:pm2rm_stkcur[ebx],ax          ;stack released
p4:
  jmp int31hok
_300h endp

;-----------------------------------------------------------------------------
; 303h DPMI func (alloc callback)
_303h proc
  pushad
  push ds
  push es
  push fs
  push gs
  mov bl,cs:callbacks
  or bl,bl
  jz int31hfail

  mov ds,cs:_selzero32
  mov edx,cs:callbackbase
  mov ecx,edx
chk1:
  cmp wptr[edx+3],0
  jz free
  add edx,25
  dec bl
  jnz chk1
  jmp int31hfail
free:
  mov bx,[esp+6]                       ; BX = caller DS from stack
  mov [edx+3],bx                       ; store callback parms in callback
  mov [edx+7],esi
  mov [edx+12],es
  mov [edx+16],edi

  sub edx,ecx                          ; DX = offset of callback
  shr ecx,4                            ; CX = segment of callback

  jmp int31hokdx                       ; return ok, with DX, CX, AX (AX unmod)
_303h endp

;-----------------------------------------------------------------------------
; 304h DPMI func
_304h proc
  pushad
  push ds
  push es
  push fs
  push gs
  cmp cx,cs:callbackseg
  jne int31hfail

  xor ebx,ebx
  mov bx,dx                            ; EBX = offset of callback

  xor ax,ax                            ; check if valid offset
  xchg dx,ax
  mov cx,25
  div cx

  or dx,dx                             ; is there a remainder
  jnz int31hfail                       ; if yes, not valid

  or ah,ah                             ; callback index too big?
  jnz int31hfail                       ; if yes, not valid

  cmp al,cs:callbacks                  ; callback index out of range?
  jae int31hfail                       ; if yes, not valid

  add ebx,cs:callbackbase              ; EBX -> callback
  mov word ptr [ebx+3],0               ; set callback as free

  jmp int31hok                         ; return ok

_304h endp

;-----------------------------------------------------------------------------
;Common INT 31h return routines

int31hokdx:
  mov wptr[esp+4*2].callstruct._edx,dx

int31hokcx:
  mov wptr[esp+4*2].callstruct._ecx,cx

int31hokax:
  mov wptr[esp+4*2].callstruct._eax,ax

int31hok:
  pop gs
  pop fs
  pop es
  pop ds
  popad
  and bptr[esp+8],0feh                 ;clear carry flag = sucessful
  iretd

int31hfail:
  pop gs
  pop fs
  pop es
  pop ds
  popad
  or bptr[esp+8],1h                    ;set flag = failed
  iretd

;-----------------------------------------------------------------------------
; int 31h func 305h  (raw/xms)

_305h proc  ;get raw mode state save/restore addr's
;   AX     = size of buffer in bytes required to save state
;   BX:CX  = segment:offset of real mode routine used to save/restore state
;   SI:EDI = selector:offset of protected mode routine used to save/restore
;            state
  xor ax,ax
  mov bx,segs16
  mov cx,cs:sr_state_rm
  mov si,selcode16
  mov edi,cs:sr_state_pm
  and bptr[esp+11],0feh  ;clear carry
  iretd
_305h endp

_306h proc   ;get raw mode switching addr's
;   BX:CX  = segment:offset of real to protected mode switch procedure
;   SI:EDI = selector:offset of protected to real mode switch procedure
  mov bx,segs16
  mov cx,cs:rm_2_pm
  mov si,selcode16
  mov edi,cs:pm_2_rm
  and bptr[esp+11],0feh  ;clear carry
  iretd
_306h endp

int31h_table_start equ $
int31h_table dw 300h,301h,302h,303h,304h,305h,306h
int31h_table_size equ ($-int31h_table_start)/2
int31h_offset dw offset _300h
              dw offset _300h
              dw offset _300h
              dw offset _303h
              dw offset _304h
              dw offset _305h
              dw offset _306h

int31h proc
  ;ax=func #
  push edi
  push ecx
  push es
  cld
  mov es,cs:_seldata16
  mov di,offset int31h_table
  mov ecx,int31h_table_size
  repnz scasw
  jnz bad
  mov edi,int31h_table_size
  sub edi,ecx
  dec edi
  shl edi,1
  add edi,offset int31h_offset
  mov di,es:[edi]
  pop es
  pop ecx
  shl edi,16         ;move into high word so we can skip over low word
  xchg edi,[esp]     ;pop edi, store RET addr
  add esp,2          ;skip over low word (it's only a 16bit addr)
  ret                ;jmp to function handler
bad:
  pop es
  pop ecx
  pop edi
  ; EIP , CS , EFlags
  or bptr[esp+8],1  ;set carry
  iretd
int31h endp

;-----------------------------------------------------------------------------
; Callback handler
callback proc                          ; real mode callback handler
  mov ax,sp                            ; preserve SS:SP for callback
  push ss
  push ax

  push gs                              ; preserve real mode regs for callback
  push fs
  push ds
  push es
  pushf                                ; preserve FLAGS for callback

  cli
  cld

  mov ebp,cs:rm2pm_stkcur              ; EBP = ESP for protected mode

  mov ebx,ebp                          ; set EBX to next stack location
  sub ebx,cs:rm2pm_stklen 
  mov cs:rm2pm_stkcur,ebx              ; update ptr for possible reenterancy

  cmp ebx,cs:rm2pm_stkend              ; exceeded protected mode stack space?
  jz critical_error                    ; if yes, critical error (hang)

  xor eax,eax                          ; EAX = base address of SS
  mov ax,ss
  shl eax,4

  xor ebx,ebx                          ;-+
  mov bx,sp                            ; EBX = current linear SS:SP
  add ebx,eax

  or eax,92000000h                     ;-+ 
  mov edi,gdt_start+selcallbackds+2    ; set for protected mode callback DS
  mov cs:[edi],eax                     ; base address in GDT

  mov ax,selzero32                     ; DS selector for protected mode
  mov dx,ax                            ; SS selector = DS selector
  mov si,selcode16                     ; target protected mode CS:EIP
  mov edi,offset cb0

  jmp cs:rm_2_pm                       ; go to protected mode

cb0:
  mov edi,[esp+14]                     ; EDI -> register structure from stack

  lea esi,[esp+24]                     ; copy general registers from stack
  mov ecx,8                            ;  to register structure
  db 67h
  rep movsd

  mov esi,esp                          ; copy FLAGS, ES, DS, FG, and GS
  db 67h
  movsw
  db 67h
  movsd
  db 67h
  movsd

  db 67h
  lodsd                                ; EAX = real mode SS:SP from stack
  add ax,42                            ; adjust SP for stuff on stack
  mov es:[edi+4],eax                   ; put in register structure

  mov ds,cs:_selcallbackds             ; DS = callback DS selector
  sub edi,42                           ; EDI -> register structure
  xor esi,esi                          ;-+
  mov si,ax                            ; ESI = old real mode SP
  xchg esp,ebp                         ; ESP = protected mode stack

  pushfd                               ; push flags for IRET from callback
  db 66h                               ;-+
  push cs                              ; push 32bit CS for IRET
  db 66h                               ;-+
  push offset cb1                      ; |
  dw 0                                 ; push 32bit EIP for IRET

  xor eax,eax
  mov ax,word ptr [ebp+22]             ; EAX = target CS of callback
  push eax                             ; push 32bit CS for RETF to callback
  push dword ptr [ebp+18]              ; push 32bit EIP for retf

  db 66h                               ; 32bit RETF to callback
  retf

cb1:
  cli
  cld

  push es                              ; DS:ESI = register structure
  pop ds
  mov esi,edi

  mov es,cs:_selzero32                 ; ES -> 0 (beginning of memory)

  xor ebx,ebx
  mov bx,word ptr [esi+2eh]            ; EBX = real mode SP from structure
  xor edx,edx
  mov dx,word ptr [esi+30h]            ; EDX = real mode SS from structure
  sub bx,42                            ; subtract size of vars to be put

  mov ebp,[esi+0ch]                    ; EBP = pushed ESP from real mode
  mov bp,bx                            ; EBP = old high & new low word of ESP

  lea edi,[edx*4]                      ; EDI -> real mode base of stack
  lea edi,[edi*4+ebx]                  ;  of vars to be stored

  mov ecx,8                            ; copy general registers to stack
  db 67h
  rep movsd

  mov eax,[esi+6]                      ; EAX = return FS and GS for real mode
  mov es:[edi],eax                     ; store on real mode stack for return

  mov ax,[esi]                         ; AX = return FLAGS for real mode
  mov es:[edi+8],ax                    ; store on real mode stack for return
  mov eax,[esi+10]                     ; EAX = return CS:IP for real mode
  mov es:[edi+4],eax                   ; store on real mode stack for return

  mov ax,[esi+4]                       ; AX = return DS for real mode
  mov cx,[esi+2]                       ; CX = return ES for real mode

  mov si,segs16                        ; real mode target CS:IP
  mov di,offset cb2

  db 66h                               ; JMP DWORD PTR, as in 32bit offset,
  jmp wptr cs:pm_2_rm                  ;  not seg:16bit offset

cb2:
  mov esp,ebp                          ; restore total ESP, old high word

  mov eax,cs:rm2pm_stklen              ; restore top of protected mode stack
  add cs:rm2pm_stkcur,eax

  popad                                ; get callback return general regs
  pop fs                               ;-+
  pop gs                               ; get callback return FS and GS values
  iret                                 ; go to callback return CS:IP
callback endp

;-----------------------------------------------------------------------------
; Rmode IRQ redirectors

irq0:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,0001h
  jmp rm_irq_redir

irq1:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,0102h
  jmp rm_irq_redir

irq2:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,0203h
  jmp rm_irq_redir

irq3:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,0304h
  jmp rm_irq_redir

irq4:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,0405h
  jmp rm_irq_redir

irq5:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,0506h
  jmp rm_irq_redir

irq6:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,0607h
  jmp rm_irq_redir

irq7:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,0708h
  jmp rm_irq_redir

irq8:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,0809h
  jmp rm_irq_redir

irq9:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,090ah
  jmp rm_irq_redir

irqa:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,0a0bh
  jmp rm_irq_redir

irqb:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,0b0ch
  jmp rm_irq_redir

irqc:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,0c0dh
  jmp rm_irq_redir

irqd:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,0d0eh
  jmp rm_irq_redir

irqe:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,0e0fh
  jmp rm_irq_redir

irqf:
  sub esp,4   ;reserve room for RETF
  push cx
  mov cx,0f10h
  jmp rm_irq_redir

rm_irq_redir proc
  push eax
  mov ax,cs:irqset
r1:
  rcr ax,1
  dec cl
  jnz r1
  jc doit

;branch onto normal IRQ handler
  push bx
  mov bx,offset old_irqs
  xor ax,ax
  mov al,ch
  shl ax,2
  add bx,ax
  mov eax,cs:[bx]
  mov [esp+8],eax
  pop bx
  pop eax
  pop cx
  retf

;redir to PMODE
doit:
  mov cs:rm_irqnum,ch
  cmp ch,8
  jb low_irq
;high_irq
  mov al,cs:picslave
  sub al,8
  jmp r2
low_irq:
  mov al,cs:picmaster
r2:
  add cs:rm_irqnum,al
  pop eax
  pop cx
  add esp,4                            ;unreserve space for RETF
  pushad                               ;-+
  push ds                              ; |
  push es                              ; |
  push fs                              ; |
  push gs                              ; Preserve all regs

  mov ax,segs16
  mov ds,ax

  xor ebp,ebp     ;-+
  mov bp,ss       ; |
  shl ebp,4       ; |
  add ebp,esp     ;ebp => TOS
  mov ax,sp
  push ss         ;-+
  push ax         ;Save current stack pos

  mov ax,selzero32
  mov cx,ax
;alloc a RM 2 PM stack
  mov ebx,rm2pm_stkcur                 ; EBX = ESP (from 0)
  mov edx,rm2pm_stklen
  cmp ebx,rm2pm_stkend
  jz critical_error
  sub rm2pm_stkcur,edx
  mov dx,ax   ;selzero32
  mov si,selcode16
  mov edi,offset doit2

  jmp cs:rm_2_pm

doit2:   ;now in PMODE
  db 0cdh
rm_irqnum db ?

  mov dx,ds:[ebp-2]
  mov bx,ds:[ebp-4]
  mov si,segs16
  mov di,offset doit3

  db 66h
  jmp wptr cs:pm_2_rm

doit3:
;release stack used
  mov eax,cs:rm2pm_stklen
  add cs:rm2pm_stkcur,eax
;pop all values off and end IRQ
  pop gs
  pop fs
  pop es
  pop ds
  popad
  iret
rm_irq_redir endp

code16seg ends

