assume cs:segs32,ds:segs32,ss:segs32,es:NOTHING

data32seg segment use32
  x dd 0     ;coords of cursor on screen
  y dd 0
  timer dw 0

;32bit messages
  msg32_timer db ' = TIMER    Ram Base=0x-------- Size=0x--------',13,0
  msg32_welcome db 'Welcome to 32bit PMODE!',13,13,0
  msg32_kbd db 'Test out the keyboard, press ESC to quit!',13,0
  msg32_fileio db 'File IO error occured!',0
  key db ?,0
  msg32_test db 'Testing int 31h ax=300h$'
  cb callstruct <>
  fn db 'test.dat',0
  dat db 1024 dup (?),0
  hand dw ?

;mouse data
  msg_nomouse db 'No Mouse Detected!',13,0
  msg_mouseok db 'Mouse init ok!',13,0
  msg_mousefail db 'Unable to init mouse!',13,0
  m_seg dw ?
  m_off dw ?
  mouse33 callstruct <>    ;this is used to call INT  33h
  mousecb callstruct <>    ;this is used for the mouse callback
  mouse_once db 0
  mouse_pos dw ?
  m_init db 0

  old_timer label fword
  dd offset ints+8
  dw selcode16
  pics dw ?

;define selectors within data32seg
  __selcode16  dw selcode16
  __seldata16  dw seldata16
  __selvid     dw selvid
  __seldata32  dw seldata32
  __selzero32  dw selzero32
  __selcode32  dw selcode32

data32seg ends

code32seg segment use32

print_reg proc,a:word,r:dword
  push es
  std
  mov es,cs:_selvid
  mov edx,r
  mov di,a
  add di,a
  mov cl,8
@@:
  mov al,dl
  shr edx,4
  and al,0fh
  .if al>=10
    add al,'a'-10
  .else
    add al,'0'
  .endif
  stosb
  dec di
  dec cl
  jnz @b
  pop es
  cld
  ret
print_reg endp

start32 proc
;reload all segment regs with 32bit selectors
  mov ax,seldata32
  mov ds,ax
  mov es,ax
  mov ss,ax
  mov fs,ax
  mov gs,ax
  mov esp,TOS32

;enable only low IRQs
  in al,0a1h
  mov ah,al
  in al,021h
  mov pics,ax
;  mov al,0ffh  ;disable all
;  out 0a1h,al
;  mov al,0ffh-3  ;disable all
;  out 021h,al

  sti  ;enable IRQs

  call clrscr   ;clear the screen

  mov esi,offset msg32_timer
  call print

  mov esi,offset msg32_welcome
  call print

  mov esi,offset msg32_kbd
  call print

  mov ax,selcode32
  mov edx,offset timer_irq
  mov bl,8
  call setint

  mov x,0
  mov y,2
  call gotoxy
;test DPMI func #300h
  mov bptr cb._eax+1,9h                ;ah=9
  mov cb._ds,segs32
  mov cb._edx,offset msg32_test        ;high part of EDX must not be used
  mov cb._ss,0                         ;-+
  mov cb._sp,0                         ;SS:SP must be zero in order to use
                                       ; system stacks
  mov edi,offset cb
  mov bx,21h                           ; BH must be 0
  mov ax,300h
  xor cx,cx
  int 31h

;test FILE IO
  mov edx,offset fn
  mov ax,3d00h  ;open file (read only)
  int 21h
  jc bad_file_io
  mov hand,ax

  xor eax,eax
  mov edx,offset dat
  mov ah,3fh    ;read from file
  mov bx,hand
  mov ecx,80  ;read upto 80 bytes
  int 21h
  jc bad_file_io

  mov x,0
  mov y,10
  call gotoxy
  mov esi,offset dat
  call print
  jmp ok1
bad_file_io:
  mov esi,offset msg32_fileio
  call print
ok1:
  mov x,0
  mov y,4
  call gotoxy

  call mouse_init   ;setup a mouse using CALLBACKs

assume ds:segs16
  mov ds,__seldata16
  mov eax,xms_base
  mov ebx,xms_size
  mov ds,_seldata32
assume ds:segs32
  push ebx
  invoke print_reg,30,eax
  pop eax
  invoke print_reg,46,eax

g1:
  mov ax,0
  int 16h

  cmp ah,1      ;is it the ESC scan code?
  jz quit       ;yes then quit
  mov key,al
  mov esi,offset key
  call print
  jmp g1

quit:
  call mouse_uninit

  cli
;restore IRQ flags
  mov ax,pics
  out 021h,al
  mov al,ah
  out 0a1h,al

  mov ax,4c00h
  int 21h  ;quit program

start32 endp

clrscr proc
  mov es,__selvid
  xor edi,edi         ;linear addr of 0b800:0  (base=0b8000h)
  mov ecx,80*25
  mov ax,720h         ;07h=white on black 20h=spaces
  rep stosw
  mov x,0
  mov y,0
  mov es,__seldata32
  ret
clrscr endp

;esi = string to print
print proc
  mov es,__selvid
p0:
  mov edi,y
  imul edi,edi,80*2    ;80*2 = # bytes/row (in text mode)d
  add edi,x
  add edi,x            ;add twice to skip over color bytes too
p1:
  cmp bptr[esi],0
  jz p3
  cmp bptr[esi],13
  jz p13
  cmp bptr[esi],10
  jz p10
  movsb                ;ds:esi => es:edi
  inc edi              ;skip over color byte
p10b:
  inc x
  cmp x,80
  jnz p1
p2:                    ;skip to next line
  mov x,0
  inc y
  cmp y,25
  jnz p0
  mov y,0
  jmp p0
p13:
  inc esi
  jmp p2
p10:
  inc esi
  jmp p10b
p3:
  mov es,__seldata32
  call gotoxy
  ret
print endp

timer_irq proc
  ;this is called during IRQ#0

  push eax
  push ds
  mov ds,cs:__seldata32
  mov ax,timer
  inc timer
  mov ds,__selvid
  mov bptr ds:[0],al
  pop ds
  pop eax

  jmp cs:old_timer

  db 0eah                              ;-+
  dd offset ints+8,selcode16           ; JMP FAR PTR selcode16:IRQ0

timer_irq endp

setint proc
  ;sets one of the exception handlers to a new 32bit location
  ;by default all INTs goto rmode
  ;in : AX=selector
  ;   :EDX=offset
  ;   : BL=INT #  
  cli  ;disable IRQs while setting INT vektor
  movzx ebx,bl
 
  mov ds,cs:__seldata16
assume ds:segs16
  mov esi,offset idt
  mov [esi+ebx*8],dx                   ; set the offset (0-15)
  mov [esi+ebx*8+2],ax                 ; set the selector
  shr edx,16
  mov [esi+ebx*8+6],dx                 ; set the offset (16-31)
  mov dl,bl
  and dl,0f8h  ;mask high 5 bits
  cmp dl,picmaster
  jnz i1
  jmp s1
i1:
  cmp dl,picslave
  jnz i2
  add bl,8
  jmp s1
i2:
  mov ds,_seldata32    ;NOTE : this is from the 16bit segment!
  sti  ;reenable IRQs
  ret
s1:
  sub bl,dl
  mov cl,bl
  mov dx,1
  shl dx,cl
  or irqset,dx
  jmp i2  
assume ds:segs32
setint endp

gotoxy proc     ;pos cursor at (x,y)
  mov ax,200h
  mov dl,byte ptr[x]
  mov bh,0
  mov dh,byte ptr[y]
  int 10h
  ret
gotoxy endp

mouse_init proc
  ;make sure there is a mouse driver
  mov ax,0
  int 33h
  cmp ax,0
  jz nomouse
  ;alloc a callback
  mov edi,offset mousecb
  mov esi,offset mouse_hand
  push cs
  pop ds
  mov ax,303h
  int 31h
  mov ds,cs:__seldata32
  jc fail
  ;cx:dx = seg:offset of callback
  mov m_init,1
  mov m_seg,cx
  mov m_off,dx
  mov mouse33._es,cx
  mov wptr mouse33._edx,dx
  mov mouse33._ecx,0ffh
  mov mouse33._eax,0ch
  mov ax,300h
  mov bx,33h
  xor ecx,ecx
  mov edi,offset mouse33
  int 31h      ;enable mouse call back feature
mouseok:
  mov esi,offset msg_mouseok
  call print
  ret
nomouse:
  mov esi,offset msg_nomouse
  call print
  ret
fail:
  mov esi,offset msg_mousefail
  call print
  ret
mouse_init endp

mouse_uninit proc
  .if m_init    ;was mouse init?
    mov mouse33._es,0
    mov mouse33._edx,0
    mov mouse33._eax,0ch
    mov mouse33._ecx,0   ;call on NONE!
    mov ax,300h
    mov bx,33h
    xor ecx,ecx
    mov edi,offset mouse33
    int 31h      ;disable mouse callback
    mov cx,m_seg
    mov dx,m_off
    mov ax,304h
    int 31h      ;release callback
  .endif
  ret
mouse_uninit endp

mouse_hand proc
  push ds
  push es
  pushad
  mov ds,cs:__seldata32
  mov cx,wptr es:[edi].callstruct._ecx
  mov dx,wptr es:[edi].callstruct._edx
  mov es,__selvid
  ;cx=horz
  ;dx=vert
  .if cx>640
    xor cx,cx
  .endif
  .if dx>200
    xor dx,dx
  .endif
  shr dx,3  ;/8
  imul dx,dx,80*2
  shr cx,3  ;/8
  add dx,cx
  add dx,cx
  inc dx   ;pt to background byte
  .if mouse_once
    mov di,mouse_pos
    xor es:[di],bptr 16
    mov di,dx
    xor es:[di],bptr 16
    mov mouse_pos,di
  .else         
    mov di,dx
    xor es:[di],bptr 16
    mov mouse_pos,di
    inc mouse_once
  .endif
  popad
  pop es
  pop ds
  db 67h
  lodsw
  mov es:[edi].callstruct._ip,ax
  db 67h
  lodsw
  mov es:[edi].callstruct._cs,ax
  add es:[edi].callstruct._sp,4
  iretd
mouse_hand endp

code32seg ends
