data16seg segment

align 4
vcpi_cr3        dd ?                   ; VCPI CR3 value for protected mode
vcpi_gdtaddx    dd offset gdtr         ; linear addx of GDT limit and base
vcpi_idtaddx    dd offset idtr         ; linear addx of IDT limit and base
vcpi_selldt     dw 0                   ; LDT selector for protected mode
vcpi_seltss     dw selvcpitss          ; TSS selector for protected mode
vcpi_eip_       dd offset vcpi_rm_2_pm2; destination EIP in protected mode
vcpi_cs_        dw selcode16           ; destination CS in protected mode

vcpistrucaddx   dd offset vcpi_cr3     ; VCPI switch structure linear address
vcpiswitchstack dd ?                   ; VCPI temporary mode switch stack

vcpi_calleip    dd ?                   ; VCPI protected mode call offset
vcpi_callcs     dw selvcpics           ; VCPI protected mode call selector

align 4
pagetablebase dd ?
pagetabletop  dd ?
pagetablefree dd ?

tempd0 label dword
tempw0 dw ?
tempw1 dw ?
tempd1 label dword
tempw2 dw ?
tempw3 dw 0

data16seg ends

code16seg segment

vcpi_detect proc                       ; detect a VCPI server
  xor ax,ax                            ; get INT 67h vector
  mov es,ax
  mov ax,es:[67h*4]
  or ax,es:[67h*4+2]                   ; is vector NULL
  jz short no_vcpi                     ; if yes, no VCPI

  mov ax,0de00h                        ; call VCPI installation check
  int 67h

  push cs
  pop es

  or ah,ah                             ; AH returned as 0?
  jnz short no_vcpi                    ; if no, no VCPI

  mov al,1                             ; VCPI detected
  ret

no_vcpi:
  xor al,al
  ret
vcpi_detect endp

vcpi_init proc                         ; VCPI protected mode init
  mov ax,0de0ah                        ; get PIC mappings
  int 67h
  mov picmaster,bl
  mov picslave,cl

  mov eax,prg_base16                   ; adjust addresses for VCPI structure
  add vcpi_gdtaddx,eax
  add vcpi_idtaddx,eax
  add vcpistrucaddx,eax

  mov dx,convram                       ; align data area on 4k page
  add dx,0ffh
  xor dl,dl
  mov convram,dx

  xor ax,ax
  mov al,vcpi_pagetables               ; AX = VCPI page table memory needed
  shl ax,8                             ; 100h paragraphs per page table
  add ax,100h+0ffh+7                   ; + page dir + align buf + TSS
  call getRAM
  xor edx,edx
  mov dx,bx
  mov es,bx
  mov eax,edx                          ; set base and top of page table area
  shl eax,4
  add eax,1000h
  mov pagetablebase,eax
  xor ecx,ecx
  mov cl,vcpi_pagetables
  shl ecx,12                           ; 4k per table
  add eax,ecx
  mov pagetabletop,eax

  xor di,di                            ; clear page dir and first page table
  mov cx,2000h/2                       ; 4k+4k = 8k
  xor ax,ax
  rep stosw

  mov gs,dx                            ; GS = segment of page directory
  lea eax,[edx+100h]
  mov es,ax                            ; ES = segment of first page table
  mov fs,ax                            ; FS = segment of first page table

  push ss                              ; stack space for VCPI descriptors
  pop ds
  sub sp,8*3                           ; VCPI will give us 3 descriptors
  mov si,sp                            ; DS:SI = buffer for VCPI descriptors

  xor di,di                            ; ES:DI = 4k table
  mov ax,0de01h                        ; get VCPI protected mode interface
  int 67h

  push cs                              ; DS = segs16
  pop ds

  xor eax,eax
  mov ax,di                            ; set base of usable page table area
  add eax,pagetablebase
  mov pagetablefree,eax

  mov vcpi_calleip,ebx                 ; store protected mode VCPI call EIP

  movzx si,dh                          ; get physical address of page dir
  shl si,2    ;*4                      ;  from first page table for CR3
  lods dword ptr fs:[si]
  mov vcpi_cr3,eax

;vil0:
;  and byte ptr es:[di+1],0f1h          ; clear bits 9-11 in copied page table
;  sub di,4                             ; bits 9-11 = AVL bits
;  jnc vil0

  mov dx,es                            ; DX = current page table segment
  xor ebx,ebx                          ; index in page dir, also loop counter
  jmp short vif0

vil1:
  xor di,di                            ; clear page table
  mov cx,1000h/2
  xor ax,ax
  rep stosw

vif0:
  add dx,100h                          ; increment page table segment
  mov es,dx

  lods dword ptr fs:[si]               ; set physical address of page table
  mov gs:[ebx*4],eax                   ;  in page directory

  inc bx                               ; increment index in page directory
  cmp bl,vcpi_pagetables               ; at end of page tables?
  jb vil1                              ; if no, loop

;-----------------------------------------------------------------------------
  xor di,di                            ; clear TSS with all 0, not really
  mov cx,34h                           ;  needed, but just to be safe
  xor ax,ax
  rep stosw

  mov eax,vcpi_cr3                     ; set CR3 in TSS
  mov es:[1ch],eax
  mov dword ptr es:[64h],680000h       ; set offset of I/O permission bitmap
                                       ;  and clear T bit

  mov ax,offset rm_2_pm_v              ;setup switching routines
  mov rm_2_pm,ax
  mov eax,offset pm_2_rm_v
  mov pm_2_rm,eax

  xor eax,eax
  mov ax,dx                       ; TSS seg
  shl eax,4                       ; set up TSS selector in GDT
  mov ebx,eax
  mov word ptr [vcpi_tss+2],ax
  shr eax,16
  mov byte ptr [vcpi_tss+4],al

  add ebx,64h-4*9                 ; unused part of TSS is also
  mov vcpiswitchstack,ebx         ;  temporary switch stack

  push cs
  pop es
  mov di,offset vcpi_cs           ; copy 3 VCPI descriptors from stack
  mov si,sp                       ;  to GDT
  mov cx,(8*3)/2
  rep movs word ptr es:[di],word ptr ss:[si]

  add sp,8*3                      ; adjust stack

;----------------------------------------------------------------------------
; Alloc Memory from VCPI server
;----------------------------------------------------------------------------
  mov inited,1  ;after the RAM alloc below we must uninit on fatal errors

  mov eax,pagetablefree
  sub eax,pagetablebase
  shl eax,10                         ;convert 4k to bytes
  mov xms_base,eax

  mov edi,pagetablefree
  mov si,di
  and si,0fh
  shr edi,4  ;convert to segment
  mov es,di
  mov ecx,pagetabletop
  shr ecx,4  ;convert to segment
  xor ebx,ebx  ;total alloc
  mov ebp,ram_max

valloc:
  .if di==cx || ebx>=ebp
done:
    mov xms_size,ebx
    push cs
    pop es
    ret
  .endif
  mov ax,0de04h
  int 67h
  or ah,ah
  jnz done
  ;edx = phy addr
  and dh,0f0h                          ; clear 4 bits of page table entry
  mov dl,7                             ; set page as user/writeable/present
  mov es:[si],edx                      ; store page in page table
  add si,4                             ; increment page table ptr
  .if si==16
    inc di
    mov es,di
    xor si,si
  .endif
  add ebx,4096
  jmp valloc
vcpi_init endp

vcpi_uninit proc
  mov edi,pagetablefree
  mov si,di
  and si,0fh
  shr edi,4  ;convert to segment
  mov es,di
  mov ecx,pagetabletop
  shr ecx,4  ;convert to segment

vfree:
  .if di==cx
    ret
  .endif
  mov edx,es:[si]                      ; get page in page table
  .if edx
    mov ax,0de05h
    int 67h
  .endif
  add si,4                             ; increment page table ptr
  .if si==16
    inc di
    mov es,di
    xor si,si
  .endif
  jmp vfree
vcpi_uninit endp

rm_2_pm_v proc                         ; VCPI real to protected switch
  pushf                                ; store FLAGS
  cli
  push cs                              ; DS = PMODE_TEXT
  pop ds
  pop tempw0                           ; move FLAGS from stack to temp
  mov tempw1,ax                        ; store AX (protected mode DS)
  mov tempw2,si                        ; store SI (protected mode CS)
  mov esi,vcpistrucaddx                ; ESI = linear addx of VCPI structure
  mov ax,0de0ch                        ; VCPI switch to protected mode
  int 67h
vcpi_rm_2_pm2::
  mov ss,dx                            ; load protected mode SS:ESP
  mov esp,ebx
  mov ds,cs:tempw1                     ; load protected mode DS
  mov es,cx                            ; load protected mode ES
  xor ax,ax
  mov fs,ax                            ; load protected mode FS with NULL
  mov gs,ax                            ; load protected mode GS with NULL
  pushfd                               ; store EFLAGS
  mov ax,cs:tempw0                     ; move bits 0-11 of old FLAGS onto
  and ah,0fh                           ;  stack for IRETD
  mov [esp],ax
  push cs:tempd1                       ; store protected mode target CS
  push edi                             ; store protected mode target EIP
  iretd                                ; go to targed addx in protected mode
rm_2_pm_v endp
;
pm_2_rm_v proc                         ; VCPI protected to real switch
  pushf                                ; store FLAGS
  cli
  push ax                              ; store AX (real mode DS)
  mov ds,cs:_selzero32                 ; DS -> 0 (beginning of memory)
  movzx ebx,bx                         ; clear high word of EBX, real mode SP
  movzx edx,dx                         ; clear high word of EDX, real mode SS
  mov eax,cs:vcpiswitchstack           ; EAX -> top of temporary switch stack
  mov dword ptr ds:[eax+32],0          ; store real mode GS
  mov dword ptr ds:[eax+28],0          ; store real mode FS
  movzx ecx,cx                         ; clear high word of ECX, real mode ES
  mov ds:[eax+20],ecx                  ; store real mode ES
  pop cx                               ; move real mode DS from protected
  mov ds:[eax+24],ecx                  ;  mode stack to VCPI call stack
  mov ds:[eax+16],edx                  ; store real mode SS
  mov ds:[eax+12],ebx                  ; store real mode SP
  mov dptr ds:[eax+4],segs16           ; store real mode CS
  mov dptr ds:[eax+0],offset v1        ; store real mode IP
  pop bx                               ; restore FLAGS from stack
  mov ss,cs:_selzero32                 ; SS -> 0 (beginning of memory)
  mov esp,eax                          ; ESP = stack ptr for VCPI call
  mov ax,0de0ch                        ; VCPI switch to real mode (V86)
  call fword ptr cs:vcpi_calleip
v1:
  push bx                              ; store old FLAGS
  push si                              ; store target CS in real mode
  push di                              ; store target IP in real mode
  iret                                 ; go to target addx in real mode
pm_2_rm_v endp

code16seg ends

