data16seg segment

int21h_table_start equ $
int21h_table db 3dh,3fh,40h
int21h_table_size equ ($-int21h_table_start)
int21h_offset dw offset x_3dh
              dw offset x_3fh
              dw offset x_40h
_8kbuffer_seg dw ?       ;segment of 8k RAM used for DOS extensions
_8kbuffer_addr dd 0      ;linear addr

int21h_old_pm label fword
  int21h_old_eip dd ?
  int21h_old_cs dw ?

data16seg ends

code16seg segment

dos_init_rm proc
  mov ax,200h  ;alloc 8k
  call getRAM

  mov _8kbuffer_seg,bx
  mov wptr _8kbuffer_addr,bx
  shl _8kbuffer_addr,4
  ret
dos_init_rm endp

dos_init_pm proc
  mov ax,204h
  mov bl,21h
  int 31h
  mov int21h_old_eip,edx
  mov int21h_old_cs,cx
  mov ax,205h
  mov bl,21h
  mov cx,cs
  mov edx,offset int21h
  int 31h
  ret
dos_init_pm endp

;-----------------------------------------------------------------------------
; INT 21h Handler (pmode)

int21h proc
  ;ah=func #
  push edi
  push ecx
  push es
  cld
  mov es,cs:_seldata16
  mov di,offset int21h_table
  mov cx,int21h_table_size
  xchg ah,al
  repnz scasb
  xchg ah,al
  jnz bad
  mov di,int21h_table_size
  sub di,cx
  dec di
  shl di,1
  add di,offset int21h_offset
  mov di,es:[di]
  pop es
  pop ecx
  shl edi,16         ;move into high word so we can skip over low word
  xchg edi,[esp]     ;pop edi, store RET addr
  add esp,2          ;skip over low word (it's only a 16bit addr)
  ret                ;jmp to function handler
bad:
  pop es
  pop ecx
  pop edi
  jmp cs:int21h_old_pm  ;cont onto int 21h rmode
int21h endp

;----------------------------------------------------------------------------
; Extended DOS Funcstions

x_3dh proc  ;open file
  ;open file
  ; DS:EDX = filename
;preserve regs
  pushad
  push es
;now we setup a callstruct to use with DPMI func 300h
  push dptr 0  ;SS:SP
  sub esp,6*2  ;es->cs
  push wptr 0  ;flags
  sub esp,8*4  ;edi->eax
  mov wptr[esp].callstruct._eax,ax
  mov es,cs:_selzero32
  mov ax,cs:_8kbuffer_seg
  mov [esp].callstruct._ds,ax
  mov wptr[esp].callstruct._edx,0
  mov esi,edx
  mov edi,cs:_8kbuffer_addr
s1:
  db 67h
  lodsb
  db 67h
  stosb
  or al,al
  jnz s1
  mov edi,esp
  push ss
  pop es
  xor ecx,ecx
  mov bx,21h
  mov ax,300h
  int 31h
  xor eax,eax
  mov ax,wptr[esp].callstruct._eax
  mov bl,bptr[esp].callstruct._flg
  add esp,32h      ;remove callstruct on stack
  pop es
  mov [esp].callstruct._eax,eax
  mov al,[esp+8*4+8]
  and bl,1
  and al,0feh
  or al,bl
  mov [esp+8*4+8],al
  popad
  iretd
x_3dh endp

x_3fh proc    ;read from file
  push es
  pushad
  sub esp,12  ;reserve room for 3 vars
  mov ebp,esp  
    v1 equ [ebp]         ;[ebp]=max to read
    v2 equ [ebp+4]       ;[ebp+4]=total read  
    v3 equ [ebp+8]       ;[ebp+8]=dest
  push dptr 0  ;SS:SP
  sub esp,6*2
  push wptr 0  ;flags
  sub esp,8*4
  mov wptr[esp].callstruct._ebx,bx
  mov ax,cs:_8kbuffer_seg
  mov [esp].callstruct._ds,ax
  mov wptr[esp].callstruct._edx,0
  mov v1,ecx             ;max to read (or what's left)
  mov v2,dptr 0          ;total read in so far
  mov v3,edx             ;dest
r1:
  mov bptr[esp].callstruct._eax+1,3fh
  mov eax,v1
  or eax,eax
  jz done
  .if eax>8*1024
    mov ax,8*1024
  .endif
  mov wptr[esp].callstruct._ecx,ax
  mov ax,300h
  mov bx,21h
  xor ecx,ecx
  push ss
  pop es
  mov edi,esp
  int 31h
;  jc crit    ;problem calling INT 21h? What to do? (crash system?)
  test [esp].callstruct._flg,1     ;is carry set?
  jnz bad
  xor ecx,ecx
  mov cx,wptr[esp].callstruct._eax
  or ecx,ecx
  jz done
;copy data from buffer to v3 (dest)
  add v2,ecx
  sub v1,ecx
  push ds
  pop es
  mov ds,cs:_selzero32
  mov esi,cs:_8kbuffer_addr
  mov edi,v3
  add v3,ecx
  mov al,cl
  shr ecx,2
  db 67h
  rep movsd
  and al,03h
  mov cl,al
  db 67h
  rep movsb
  push es
  pop ds
  jmp r1
done:
  mov eax,v2       ;total read in
  add esp,32h+12   ;pop off old callstruct and local vars
  mov [esp].callstruct._eax,eax
  popad
  pop es
  and bptr[esp+8],0feh  ;clear carry flag
  iretd
bad:
  xor eax,eax
  mov ax,wptr[esp].callstruct._eax
  add esp,32h+12
  mov [esp].callstruct._eax,eax    ;give error code
  popad
  pop es
  or bptr[esp+8],1  ;set carry flag
  iretd
x_3fh endp

x_40h proc  ;write to file
  push es
  pushad
  sub esp,12  ;reserve room for 3 vars
    v1 equ [ebp]      ;[ebp]=max to write
    v2 equ [ebp+4]      ;[ebp+4]=total written  
    v3 equ [ebp+8]      ;[ebp+8]=dest   
  mov ebp,esp  
  push dptr 0
  sub esp,6*2
  push wptr 0
  sub esp,8*4
  mov wptr[esp].callstruct._ebx,bx
  mov ax,cs:_8kbuffer_seg
  mov [esp].callstruct._ds,ax
  mov wptr[esp].callstruct._edx,0
  mov v1,ecx        ;max to write (or what's left)
  mov v2,dptr 0     ;total written so far
  mov v3,edx        ;dest
w1:
  mov bptr[esp].callstruct._eax+1,40h
  mov eax,v1
  or eax,eax
  jz done
  .if eax>8*1024
    mov ax,8*1024
  .endif
  mov wptr[esp].callstruct._ecx,ax
  xor ecx,ecx
  mov cx,ax
;copy from v3 (src) to 8kbuffer
  mov es,cs:_selzero32
  mov edi,cs:_8kbuffer_addr
  mov esi,v3
  add v3,ecx
  mov al,cl
  shr ecx,2
  db 67h
  rep movsd
  and al,3
  mov cl,al
  db 67h
  rep movsb
  push es
  pop ds
;call DOS now
  mov ax,300h
  mov bx,21h
  xor ecx,ecx
  push ss
  pop es
  mov edi,esp
  int 31h
  test [esp].callstruct._flg,1
  jnz bad
  xor eax,eax
  mov ax,wptr[esp].callstruct._eax
  or eax,eax
  jz done
  add v2,eax
  sub v1,eax
  jmp w1
done:
  mov eax,v2       ;total written
  add esp,32h+12
  mov [esp].callstruct._eax,eax
  popad
  pop es
  and bptr[esp+8],0feh  ;clear carry flag
  iretd
bad:
  xor eax,eax
  mov ax,wptr[esp].callstruct._eax
  add esp,32h+12
  mov [esp].callstruct._eax,eax     ;give error code
  popad
  pop es
  or bptr[esp+8],1  ;set carry flag
  iretd
x_40h endp

code16seg ends

