option language:c      ;to allow INVOKE
option proc:private    ;no need to waste OBJ space

; Stage #8
; - full DPMI funcs/DOS funcs
; - memory manager under raw/xms/vcpi

;This program will not work if a DPMI server is loaded (without a VCPI server)
;So you can not have Windoze or OS/2 loaded while using this little example
; (don't worry, eventually this will run under those programs but not yet).

; New stuff: see init_rxv proc (in _raw.asm)
;  and many _xxxh funcs in _raw.asm (DPMI funcs)
;  and many x_xxh funcs in _dos.asm (DOS extensions)
;  and see _ram.asm for the new memory manager

.386p   ;allow USE32 and 386 instructions
;-----------------------------------------------------------------------------
;some EQUates
;-----------------------------------------------------------------------------
stack16siz equ 1024*2
stack32siz equ 1024*4

bptr equ byte ptr
wptr equ word ptr
dptr equ dword ptr
fptr equ fword ptr
qptr equ qword ptr

ERROR equ -1

VERSION_HI equ 0
VERSION_LO equ 10
VERSION_STR equ '0.10'

;----------------------------------------------------------------------------
;define all segments that will be needed
;----------------------------------------------------------------------------
code16seg segment use16 'code'
code16seg ends
data16seg segment use16
data16seg ends
stack16seg segment use16 stack
  db stack16siz dup (?)
  TOS16 equ $   ;top of stack
stack16seg ends

include _cfg.asm

code32seg segment use32 'code'
code32seg ends
data32seg segment use32
data32seg ends
stack32seg segment use32 'stack'
  db stack32siz dup (?)
  TOS32 equ $   ;top of stack
stack32seg ends

;put all segments in one
segs16 group code16seg,data16seg,stack16seg
segs32 group code32seg,data32seg,stack32seg

assume cs:segs16,ds:segs16,ss:segs16,es:NOTHING

;-----------------------------------------------------------------------------
;data structs needed
;-----------------------------------------------------------------------------
desc struct   ;define our descriptor structure
  limit_lo dw ?    ;limit bits 15-0
  base_lo dw ?     ;base bits 15-0
  base_mid db ?    ;base bits 23-16
  type1 db ?       ;type of selector
  limit_hi db ?    ;limit bits 19-16 and other info
  base_hi db ?     ;base bits 31-24
desc ends

callstruct struct  ;used in calling rmode
  _edi dd ?     ;0
  _esi dd ?     ;4
  _ebp dd ?     ;8
  _res dd ?     ;0ch reserved
  _ebx dd ?     ;10h
  _edx dd ?     ;14h
  _ecx dd ?     ;18h
  _eax dd ?     ;1ch
  _flg dw ?     ;20h flags
  _es dw ?      ;22h segments (NOT selectors)
  _ds dw ?      ;24h "
  _fs dw ?      ;26h "
  _gs dw ?      ;28h "
  _ip dw ?      ;2ah ignored when calling INT
  _cs dw ?      ;2ch "
  _sp dw ?      ;2eh must be 0 to use system stacks
  _ss dw ?      ;30h "
callstruct ends

;-----------------------------------------------------------------------------
;16bit data segment
;-----------------------------------------------------------------------------
data16seg segment use16  ;start defining our 16bit data

  inited db 0      ;this is set after RAW/XMS/VCPI has init
                   ; if after that a fatal error occurs it will be know
                   ; that exit16error: should uninit

;define our GDTR
  gdtr label fword
  gdt_limit dw gdt_size-1
  gdt_addr dd ?
  gdt_end dd 0     ;used to scroll thru GDT entries
;define our IDTR
  idtr label fword
  idt_limit dw idt_size-1
  idt_addr dd ?
;define the default IDTR (this is used while in RMODE)
  rm_idtr label fword
  dw 3ffh  ;limit
  dd 0     ;addr

;-----------------------------------------------------------------------------
;define our GDT
;-----------------------------------------------------------------------------
align 4
  gdt_start equ $
  null desc <0,0,0,0,0,0>
    ;this is the 1st GDT entry called NULL which we can not use
  code16 desc <0ffffh,?,?,10011010b,0h,?>
    ;Limit=64 KBs (this is a 16bit segment so only IP is used while running)
    ;Base=? (this will be setup later in the program)
    ;10011?10b = P=1 (present), DPL=0, S=1(code/data segment) T=1 (code)
    ;            C=0(non-conforming), R=1 (readable), A=0 (not accessed)
    ;0h = limit bits 19-16=0, G=0 (1byte granularity), D=0 (16bit segment)
  data16 desc <0ffffh,?,?,10010010b,0h,?>
    ;Limit=64 KBs
    ;Base=? (this will be setup later in the program)
    ;10010010b = P=1 (present), DPL=0, S=1(code/data segment) T=0 (data)
    ;            E=0 (do not expand down), W=1 (writable), A=0 (not accessed)
    ;0h = limit bits 19-16=0, G=0 (1byte granularity), D=0 (16bit segment)
  callbackds desc <0ffffh,?,?,10010010b,0h,0>
    ;Limit=64 KBs
    ;Base=? (this will be setup each time a callback is used to point to
    ;        the rmode stack segment)
    ;10010010b = P=1 (present), DPL=0, S=1(code/data segment) T=0 (data)
    ;            E=0 (do not expand down), W=1 (writable), A=0 (not accessed)
    ;0h = limit bits 19-16=0, G=0 (1byte granularity), D=0 (16bit segment)
  vid desc <0ffffh,8000h,0bh,10010010b,0h,0>
    ;Limit=64 KBs
    ;Base=0b8000h (makes it easy to access video RAM while in PMODE)
    ;10010010b = P=1 (present), DPL=0, S=1(code/data segment) T=0 (data)
    ;            E=0 (do not expand down), W=1 (writable), A=0 (not accessed)
    ;0h = limit bits 19-16=0, G=0 (1byte granularity), D=0 (16bit segment)
  code32 desc <0ffffh,?,?,10011010b,11001111b,?>
    ;Limit=4 GBs (0ffffh * 4k = 4 GBs)
    ;Base=?
    ;     the beginning of memory)
    ;10011110b = P=1 (present), DPL=0, S=1(code/data segment) T=1 (code)
    ;            C=0(non-conforming), R=1 (readable), A=0 (not accessed)
    ;11001111b = limit bits 19-16=0fh, G=1 (4k granularity), D=1 (32bit segment)
  data32 desc <0ffffh,?,?,10010010b,11001111b,?>
    ;Limit=4 GBs
    ;Base=?
    ;10010010b = P=1 (present), DPL=0, S=1(code/data segment) T=0 (data)
    ;            E=0 (do not expand down), W=1 (writable), A=0 (not accessed)
    ;11001111b = limit bits 19-16=0fh, G=1 (4k granularity), D=1 (32bit segment)
  zero32 desc <0ffffh,0,0,10010010b,11001111b,0>
    ;Limit=4 GBs
    ;Base=0h (easy access to rmode memory)
    ;10010010b = P=1 (present), DPL=0, S=1(code/data segment) T=0 (data)
    ;            E=0 (do not expand down), W=1 (writable), A=0 (not accessed)
    ;11001111b = limit bits 19-16=0fh, G=1 (4k granularity), D=1 (32bit segment)
  vcpi_tss desc <67h,?,?,10001001b,0,?>  ;89h
    ;Limit=68h bytes (size of TSS needed)
    ;Base=? (setup later)
    ;10001001b = P=1 (present), DPL=0, S=0(system segment)
    ;            TYPE=9 (avail 386 TSS)
  vcpi_cs desc <>     ;These 3 desc are needed by VCPI servers
  vcpi_1 desc <>      ;they will be setup later
  vcpi_2 desc <>
  gdt_size equ ($-gdt_start)

;-----------------------------------------------------------------------------
;define our IDT (pmode)
;-----------------------------------------------------------------------------
align 4
  idt_start equ $
  idt desc 256 dup (<?,selcode16,0,10001110b,0,0>)
  idt_size equ ($-idt_start)

;define our selectors as EQU
  selcode16 equ (offset code16-gdt_start)
  seldata16 equ (offset data16-gdt_start)
  selcallbackds equ (offset callbackds-gdt_start)
  selvid equ    (offset vid   -gdt_start)
  seldata32 equ (offset data32-gdt_start)
  selzero32 equ (offset zero32-gdt_start)
  selcode32 equ (offset code32-gdt_start)
  selvcpitss equ (offset vcpi_tss-gdt_start)
  selvcpics equ (offset vcpi_cs-gdt_start)

;define our selectors as DW
  _selcode16  dw selcode16
  _seldata16  dw seldata16
  _selcallbackds dw selcallbackds
  _selvid     dw selvid
  _seldata32  dw seldata32
  _selzero32  dw selzero32
  _selcode32  dw selcode32
  _selvcpitss dw selvcpitss
  _selvcpics  dw selvcpics

;define our raw switching routines
  pm_2_rm dd offset pm_2_rm_rx         ;by default our switching routines
  rm_2_pm dw offset rm_2_pm_rx         ;will be for raw/xms but later it may
                                       ;become VCPI
;define our save/restore state routines
  sr_state_pm dd offset sr_state_pm_rx
              dd selcode16
  sr_state_rm dw offset sr_state_rm_rx
              dw segs16

;define our callbacks info
  callbackbase dd ?
  callbackseg dw ?

align 4
;-----------------------------------------------------------------------------
;define our pm 2 rm stacks (these are segmented - ie: para sized)
  pm2rm_stkend dw 0       ;Last avail stack   (ss)
  pm2rm_stkcur dw 0       ;Current            (ss)
;define our rm 2 pm stacks (these will be used as linear addr'es)
  rm2pm_stkend dd 0       ;Last avail stack   (ss)
  rm2pm_stkcur dd 0       ;Current            (ss)
;-----------------------------------------------------------------------------

;define temp variables needed
  ;...

convram dw ?             ;Base of conventional RAM left

mode db 0                ;defines what drivers are installed
  MODE_RAW equ 0         ;none
  MODE_XMS equ 1         ;XMS (himem.sys)
  MODE_VCPI equ 2        ;VCPI (Emm386.exe)  Not supported yet
  MODE_DPMI equ 3        ;DPMI (Winblows)  Not supported yet

cpu db ?                 ;detected CPU  (3=386 4=486 5=586)

align 4
prg_base16 dd ?                        ;segs16 * 10h
prg_base32 dd ?                        ;segs32 * 10h

old_int21h_rm dd ?                     ;old rmode int 21h handler

picslave  db 70h                       ; PIC slave base interrupt
picmaster db 8h                        ; PIC master base interrupt

psp dw ?                               ;program segment prefix

;-----------------------------------------------------------------------------
;messages
;-----------------------------------------------------------------------------
msg_welcome db 'DOS extender Tutorial : Stage #7',13,10,'$'
msg_80386 db '80386 or better required!',13,10,'$'
msg_v86 db 'Another PMODE software is already loaded!',13,10,'$'
msg_clean_boot db 'Please use a clean boot to use this tutorial!',13,10,'$'
msg_no_ram db 'Insufficent conventional memory!',13,10,'$'
msg_lh db 'This can not be loaded high!',13,10,'$'

msg_copyright db 'QMODE : Protected Mode Tutorials ( by : Peter Quiring )',0
data16seg ends

;-----------------------------------------------------------------------------
;16bit code segment
;-----------------------------------------------------------------------------
code16seg segment use16  ;start the 16bit code segment

;this is used to report errors and quit the program
exit16error:
  mov ah,9
  int 21h                              ;print error message
  mov dx,offset msg_clean_boot
  mov ah,9
  int 21h                              ;print clean boot message
  .if inited
    .if mode==MODE_RAW
      call raw_uninit
    .elseif mode==MODE_XMS
      call xms_uninit
    .elseif mode==MODE_VCPI
      call vcpi_uninit
    .endif
  .endif
  mov ax,4c00h
  int 21h                              ;exit program

;this will detect if the CPU is a 80386 or better
;Return : cl = processor type  (2=286 3=386 4=486 5=586)
detect_processor proc             ; get processor: 286, 386, 486, or 586
  xor cx,cx                       ; processor type 0 in case of exit

  pushf                           ; transfer FLAGS to BX
  pop bx

  mov ax,bx                       ; try to clear high 4 bits of FLAGS
  and ah,0fh

  push ax                         ; transfer AX to FLAGS
  popf
  pushf                           ; transfer FLAGS back to AX
  pop ax

  and ah,0f0h                     ; isolate high 4 bits
  cmp ah,0f0h
  je short detect_processordone   ; if bits are set, CPU is 8086/8

  mov cl,2                        ; processor type 2 in case of exit

  or bh,0f0h                      ; try to set high 4 bits of FLAGS

  push bx                         ; transfer BX to FLAGS
  popf
  pushf                           ; transfer FLAGS to AX
  pop ax

  and ah,0f0h                     ; isolate high 4 bits
  jz short detect_processordone   ; if bits are not set, CPU is 80286

  inc cx                          ; processor type 3 in case of exit

  push eax                        ; preserve 32bit registers
  push ebx     

  pushfd                          ; transfer EFLAGS to EBX
  pop ebx

  mov eax,ebx                     ; try to flip AC bit in EFLAGS
  xor eax,40000h

  push eax                        ; transfer EAX to EFLAGS
  popfd
  pushfd                          ; transfer EFLAGS back to EAX
  pop eax

  xor eax,ebx                     ; AC bit fliped?
  jz short detect_processordone2  ; if no, CPU is 386

  inc cx                          ; processor type 4 in case of exit

  mov eax,ebx                     ; try to flip CPUID bit in EFLAGS
  xor eax,200000h

  push eax                        ; transfer EAX to EFLAGS
  popfd
  pushfd                          ; transfer EFLAGS back to EAX
  pop eax

  xor eax,ebx                     ; ID bit fliped?
  jz short detect_processordone2  ; if no, CPU is 486

  inc cx                          ; processor type 5, CPU is 586

detect_processordone2:
  pop ebx                         ; restore 32bit registers
  pop eax    

detect_processordone:
  ret                             ; return
detect_processor endp

start16 proc                      ;this is where our program starts
  mov bx,es                       ;save the PSP

  cld

  mov ax,cs
  mov ds,ax         
  mov es,ax                       ;set DS=ES=CS

  mov psp,bx

  mov ss,ax                       ;force SS to segs16
  mov sp,TOS16

  mov dx,offset msg_welcome       ;-+
  mov ah,9                        ; |
  int 21h                         ;print Welcome message

  cmp psp,0a000h
  jb ok1
  mov dx,offset msg_lh
  jmp exit16error
ok1:

;determine if CPU is a 80386 or better
  call detect_processor
  cmp cl,3
  jae ok_386
  mov dx,offset msg_80386
  jmp exit16error                      ;if CPU is under 386 then quit
ok_386:
  mov cpu,cl  ;save for later

;setup program bases
  xor eax,eax
  mov ax,cs
  shl eax,4                            ; convert to linear addr
  mov prg_base16,eax

  xor eax,eax
  mov ax,segs32
  shl eax,4                            ; convert to linear addr
  mov prg_base32,eax
;setup all our descriptors
  mov eax,prg_base16
  mov code16.base_lo,ax
  mov data16.base_lo,ax
  shr eax,16
  mov code16.base_mid,al
  mov data16.base_mid,al
;  mov code16.base_hi,ah               ;not needed since AH will always be 0
;  mov data16.base_hi,ah               ; "

  mov eax,prg_base32
  mov code32.base_lo,ax
  mov data32.base_lo,ax
  shr eax,16
  mov code32.base_mid,al
  mov data32.base_mid,al
;  mov code32.base_hi,ah               ; "
;  mov data32.base_hi,ah               ; "

;find end of RAM after EXE
  mov bx,segs32
  mov ax,TOS32
  add ax,0fh
  shr ax,4
  add bx,ax                            ;bx => end of program in RAM
  mov convram,bx

  call dos_init_rm

;server detection/init phase
  .if vd_order==0  ;VCPI first?
    call vcpi_detect
    .if al==1
      jmp vcpi_present
    .else
      call dpmi_detect
      .if al==1
        jmp dpmi_present
      .endif
    .endif
  .else
    call dpmi_detect
    .if al==1
      jmp dpmi_present
    .else
      call vcpi_present
      .if al==1
        jmp vcpi_present
      .endif
    .endif
  .endif
  call chk_v86
  call xms_detect
  .if al==1
    mov mode,MODE_XMS
    call xms_init
    jmp cont_init
  .endif
  call raw_init
  jmp cont_init

vcpi_present:
  mov mode,MODE_VCPI
  call vcpi_init
  jmp cont_init

dpmi_present:
  mov mode,MODE_DPMI
  call dpmi_init
  jmp cont_init2

cont_init:                             ; Raw/XMS/VCPI

;misc GDT/IDT/callbacks setup
  call init_rxv

  call freeRAM

;install rmode IRQ redirectors
  call irq_init

;clear NT and IOPL
  pushf
  mov bp,sp
  and wptr [bp+1],08fh ;40h = NT bit , 30h = IOPL bits
  popf 

;install our INT 21h handler (rmode)  [RAW/XMS/VCPI]
  mov ax,3521h
  int 21h            ;get int 21h
  mov wptr[old_int21h_rm+2],es
  mov wptr[old_int21h_rm+0],bx
  push ds
  pop es

  mov ah,25h
  mov dx,offset int21h_rm
  int 21h            ;set int 21h

cli
  mov ax,seldata16
  mov cx,seldata16
  mov dx,ax
  mov ebx,TOS16
  mov si,selcode16
  mov edi,offset cont_init_rxv2
  jmp rm_2_pm

cont_init_rxv2:
  call ram_init

cont_init2:  ;now in 16bit PMODE

  call dos_init_pm

;setup a IRETD that will jump into our 32bit segment

  pushfd
  push wptr 0
  push wptr _selcode32
  push dptr offset start32
  iretd   ;goto 32bit segment

start16 endp

critical_error proc                    ; some unrecoverable error
  cli                                  ; make sure we are not interrupted
  in al,61h                            ; beep
  or al,3
  out 61h,al
  jmp $                                ; now hang
critical_error endp

getRAM proc  ;get conventional RAM
  ; in : ax=# paras
  ; out: bx=segment
  mov bx,convram
  add ax,bx
  cmp ax,0a000h
  ja bad
  mov convram,ax
  ret
bad:
  mov dx,offset msg_no_ram
  jmp exit16error
getRAM endp

freeRAM proc
;free unneeded conv RAM
  mov cx,psp
  mov es,cx       ;block to resize
  mov bx,convram
  sub bx,cx       ;new size
  add bx,10
  mov ah,4ah
  int 21h    ;bug                          ;resize memory block
  push cs
  pop es          ;reset ES
  ret
freeRAM endp

code16seg ends

include _raw.asm
include _xms.asm
include _vcpi.asm
include _dpmi.asm
include _dos.asm
include _demo.asm

end start16     ;start program in segs16:start16

