data16seg segment

align 4
dpmi_bufsiz dw ?        ;buffer size needed by DPMI server
dpmi_call label dword   ;-+
dpmi_ip dw ?            ; |
dpmi_cs dw ?            ;Far PROC to call to transfer into PMODE
dpmi_access db ?        ;Access rights of CS
dpmi_bs dw ?            ;Base selector of selectors alloc
dpmi_inc dw ?           ;Increment value of selectors

msg_no32dpmi db 'DPMI host is not 32bit!',13,10,'$'
msg_dpmifailed db 'Failed to jump to PMODE under DPMI',13,10,'$'

data16seg ends

code16seg segment

dpmi_detect proc
  mov ax,1687h
  int 2fh
  or ax,ax
  jnz noDPMI
  test bl,1
  jz no32bit
  mov dpmi_bufsiz,si
  mov dpmi_cs,es
  mov dpmi_ip,di
  mov al,1
  push cs
  pop es
  ret
noDPMI:
  xor al,al
  push cs
  pop es
  ret
no32bit:
  mov dx,offset msg_no32dpmi
  jmp exit16error
  xor al,al
  push cs
  pop es
  ret
dpmi_detect endp

dpmi_init proc
  mov ax,dpmi_bufsiz
  call getRAM
  push bx
  call freeRAM
  pop es
  mov ax,1    ;tell DPMI server that this is a 32bit program
  call cs:[dpmi_call]
  jnc inPMODE
  mov dx,offset msg_dpmifailed
  jmp exit16error
inPMODE:
  ; now CS = 16bit selector limit=64k base=segs16 (code)
  ;     DS,SS = 32bit selector limit=64k base=segs16 (data)
  ;     ES = 32bit selector limit=100h base=psp segment
  ;     FS,GS = 0
  ;     ESP - high word will be cleared
  ; note : if DS=SS when calling [dpmi_call] then only 1 selector will be
  ;        alloc'ed for both

  mov ax,ds
  mov es,ax
  mov fs,ax
  mov gs,ax

  mov ax,cs
  lar bx,ax
  mov dpmi_access,bh
  and bh,001100000b  ;mask PL bits
  mov di,offset vid+5
  mov cl,4
d1:
  or [di],bh         ;set PL bits
  add di,8
  dec cl
  jnz d1
;setup 4 new selectors for VID,CODE32,DATA32 and ZERO32
  xor ax,ax   ;DPMI func 0000h (alloc selectors)
  mov cx,4    ; 4 selectors needed
  int 31h
  jc nosel
  mov dpmi_bs,ax  ;base selector
  mov ax,3
  int 31h
  mov dpmi_inc,ax ;increment value
  xor edi,edi
  mov di,offset vid
  mov bx,dpmi_bs
  mov cl,4
  mov dx,dpmi_inc
  mov ax,0ch
d2:
  int 31h      ;set selector with 8 byte buffer (bx=sel es:edi=buffer)
  add bx,dx
  add di,8
  dec cl
  jnz d2
;setup selectors (in data16)
  mov _selcode16,cs
  mov _seldata16,ds
  mov ax,dpmi_bs
  mov bx,dpmi_inc
  mov _selvid,ax
  add ax,bx
  mov _selcode32,ax
  add ax,bx
  mov _seldata32,ax
  add ax,bx
  mov _selzero32,ax
;setup selectors (in data32)
assume es:segs32
  mov es,_seldata32
  mov es:__selcode16,cs
  mov es:__seldata16,ds
  mov ax,dpmi_bs
  mov bx,dpmi_inc
  mov es:__selvid,ax
  add ax,bx
  mov es:__selcode32,ax
  add ax,bx
  mov es:__seldata32,ax
  add ax,bx
  mov es:__selzero32,ax
assume es:segs16
  mov es,_seldata16
  ret

nosel:           ;can't print an error message thru DOS yet (pmode)
  mov ax,4c00h
  int 21h
dpmi_init endp

code16seg ends

