heads struct  ;12bytes
  magic dw ? ; 'PQ' ;signature (it will be 'QP' thru out this file cause of intel byte swap)
  flag db ?  ;bit0=free(1)  bit1=last(2)   (1==true)
  _a1 db ?   ;junk byte for alignment (not used!)
  prev dd ?  ;ptr=>previous block
  siz dd ?   ;size of this block
heads ends

MB_FREE equ 1
MB_LAST equ 2
ERROR equ -1

ram_init proc
  push ds
  mov eax,xms_base
  mov ebx,xms_size
  mov ds,cs:_selzero32
  .if !ebx
    pop ds
    mov xms_base,ebx  ;ensure it's 0
    ret
  .endif
  sub ebx,sizeof heads
  mov word ptr[eax].heads.magic,'QP'   ;=50,51
  mov byte ptr[eax].heads.flag,3h      ;last&free
  mov dword ptr[eax].heads.prev,0      ;no prev!
  mov dword ptr[eax].heads.siz,ebx
  pop ds
  ret
ram_init endp

_500h proc  ;get Free mem avail. (es:edi = 48 byte buffer)
  push ds
  pushad
  mov ds,cs:_selzero32

  call __qfree

  db 67h
  stosd
  mov ecx,44/4
  mov eax,-1  ;set unknown fields to (0ffffffffh)
  cld
  db 67h
  rep stosd

  popad
  pop ds
  and bptr[esp+8],0feh
  iretd  
_500h endp

_501h proc  ;alloc RAM  (bx:cx = size req) (bx:cx = linear si:di=handle)
  push ds
  pushad
  mov ds,cs:_selzero32

  shl ebx,16
  mov bx,cx
  push ebx
  call __malloc
  add esp,4
  or eax,eax   ;is it NULL?
  jnz success

fail:
  popad
  pop ds
  or bptr[esp+8],1
  iretd

success:
  mov wptr[esp].callstruct._ecx,ax
  mov wptr[esp].callstruct._edi,ax
  shr eax,16
  mov wptr[esp].callstruct._ebx,ax
  mov wptr[esp].callstruct._esi,ax
  popad
  pop ds
  and bptr[esp+8],0feh
  iretd
_501h endp

_502h proc ;free mem  (si:di = handle)
  push ds
  pushad
  mov ds,cs:_selzero32

  mov ax,si
  shl eax,16
  mov ax,di
  push eax
  call __free
  pop ecx
  or al,al
  jz success

fail:
  popad
  pop ds
  or bptr[esp+8],1
  iretd

success:
  popad
  pop ds
  and bptr[esp+8],1
  iretd
_502h endp

_503h proc  ;resize block  (bx:cx = new size  si:di=handle) (returns in same)
  push ds
  pushad
  mov ds,cs:_selzero32
  shl ebx,16
  mov bx,cx  ;EBX = size
  shl esi,16
  mov si,di  ;ESI = handle

  push ebx
  push esi
  call __realloc
  add esp,8
  or eax,eax
  jnz success

fail:
  popad
  pop ds
  or bptr[esp+8],1
  iretd

success:
  mov wptr[esp].callstruct._ecx,ax
  mov wptr[esp].callstruct._edi,ax
  shr eax,16
  mov wptr[esp].callstruct._ebx,ax
  mov wptr[esp].callstruct._esi,ax
  popad
  pop ds
  and bptr[esp+8],0feh
  iretd
_503h endp

__malloc proc   ;,sz:dword

  push ebp
  mov ebp,esp
  Psiz equ dptr[ebp+6]

  cmp Psiz,0
  jnz @f
bad:
  mov eax,0
  pop ebp
  ret
@@:
  ;make sure alloc block is dword aligned
  add Psiz,3
  and Psiz,0ffffffffh-3
  ;search thru chain for best fit
  mov eax,cs:xms_base  ;ram start
  mov ebx,0     ;best fit location
  mov ecx,-1    ;best fit is ecx too much over Psiz
start:
  mov dl,[eax].heads.flag
  test dl,MB_FREE
  jnz ok3
next:
  mov dl,[eax].heads.flag
  test dl,MB_LAST
  jnz endsrc
  add eax,[eax].heads.siz
  add eax,sizeof heads
  jmp start
ok3:
  ;found one that's free
  mov edx,[eax].heads.siz
  sub edx,Psiz
  jb next ;too small
  ;found one big enough
  cmp edx,ecx
  jae next ;already got another that's better
  ;this one's better
  mov ecx,edx
  mov ebx,eax
  jmp next
endsrc:
  ;end of search
  cmp ebx,0
  jz bad
;split ebx into 2 blocks:1st = used 2nd = free
  mov eax,ebx
  xor [ebx].heads.flag,1  ;set as used!
  cmp ecx,256  ;don't make a really small block
  ja ok4
  add ecx,Psiz
  mov [ebx].heads.siz,ecx  ;set size (all of it)
  add eax,sizeof heads
  pop ebp
  ret
ok4:
  mov edx,Psiz
  mov al,[ebx].heads.flag
  and al,MB_LAST        ;mask last
  xor [ebx].heads.flag,al  ;remove last if it's there
  mov [ebx].heads.siz,edx ;set size
  add edx,ebx
  add edx,sizeof heads
  mov [edx].heads.magic,'QP'  ;free only
  mov [edx].heads.flag,MB_FREE
  or [edx].heads.flag,al  ;set if last
  mov [edx].heads.prev,ebx  ;set prev
  sub ecx,sizeof heads
  mov [edx].heads.siz,ecx  ;set size
  mov eax,ebx
  add eax,sizeof heads
  pop ebp
  ret
__malloc endp

__free proc,b:dword

  push ebp
  mov ebp,esp
  Pblk equ dptr[ebp+6]

  mov eax,Pblk
  cmp eax,0
  jnz ok6
bad:
  mov eax,ERROR
  pop ebp
  ret
ok6:
  sub eax,sizeof heads
  cmp eax,cs:xms_base
  jz ok7 ;no above!
  mov ebx,[eax].heads.prev
  test [ebx].heads.flag,MB_FREE
  jz ok7
  ;above is free

  mov dl,[eax].heads.flag  ;must copy flags to above block
  mov ecx,[eax].heads.siz
  mov eax,ebx
  add ecx,sizeof heads
  add [eax].heads.siz,ecx
  mov [eax].heads.flag,dl
ok7: ;done joining with above block
  mov ebx,[eax].heads.siz
  add ebx,eax
  add ebx,sizeof heads
  test byte ptr[ebx].heads.flag,MB_FREE
  jz ok8
  mov ecx,[ebx].heads.siz
  add ecx,sizeof heads
  add [eax].heads.siz,ecx
  mov dl,[ebx].heads.flag
  mov [eax].heads.flag,dl
ok8: ;done joining below
  or [eax].heads.flag,MB_FREE  ;mark as free
  xor eax,eax
  pop ebp
  ret
__free endp

__qfree proc ;query free ram  ;out:eax=largest
  mov ecx,cs:xms_base
  .if !ecx
    xor eax,eax
    ret
  .endif
  xor eax,eax  ;largest block
  xor edx,edx  ;size of last block
  sub ecx,sizeof heads
start:
  add ecx,sizeof heads
  add ecx,edx
  mov edx,[ecx].heads.siz
  test [ecx].heads.flag,MB_FREE
  jz nope
  cmp edx,eax
  jb nope
  mov eax,edx
nope:
  test [ecx].heads.flag,MB_LAST
  jz start
  ret
__qfree endp

__realloc proc   ;,p:dword,siz:dword
  ;1st: attempts to see if next block is free and the simply enlarges
  ;     the block as needed
  ;2nd: alloc a new block and copies to it and then releases old block
  ; NOTE : This func is slightly modified from ANSI C's realloc()

  push ebp
  mov ebp,esp
  Pblk equ dptr[ebp+6]
  Psiz equ dptr[ebp+10]

  mov eax,Pblk
  sub eax,sizeof heads     ;FIX : v2.00 Beta #4 : this was after .if
  .if wptr[eax].heads.magic!='QP'
    mov eax,0  ;NULL?
    pop ebp
    ret
  .endif
  mov ebx,[eax].heads.siz
  .if ebx==Psiz  ;requested same size
    mov eax,Pblk   ;nothing to do
    pop ebp
    ret
  .endif
  .if ebx<Psiz
    ;make smaller
    mov ecx,ebx
    sub ecx,Psiz
    .if ecx<256
      ;don't make the new block too small
      mov eax,Pblk
      pop ebp
      ret
    .endif
    ;split Pblk into 2 blocks!
    mov ebx,Psiz
    mov edx,[eax].heads.siz
    mov [eax].heads.siz,ebx
    mov cl,[eax].heads.flag
    mov ebx,eax
    add ebx,Psiz
    add ebx,sizeof heads
    mov [ebx].heads.magic,'QP'
    mov [ebx].heads.flag,cl
    or [ebx].heads.flag,MB_FREE   ;set as free
    sub edx,Psiz
    mov [ebx].heads.prev,eax
    sub edx,sizeof heads
    mov [ebx].heads.siz,edx
    mov eax,Pblk
    pop ebp
    ret
  .else
    ;make bigger (if possible)
    .if [eax].heads.flag & MB_LAST
      jmp _2nd ;this is the last one
    .endif
    mov ecx,eax
    add ecx,ebx
    add ecx,sizeof heads
    .if ! ([ecx].heads.flag & MB_FREE)
      jmp _2nd  ;the block below is not free
    .endif
    mov edx,[ecx].heads.siz
    add edx,sizeof heads
    ;if edx+ebx >= Psiz then we can do it!
    add edx,ebx
    .if (Psiz > edx)
      jmp _2nd
    .endif
    mov ebx,edx
    sub ebx,Psiz
    .if ebx<256  ;don't make too small
      mov [eax].heads.siz,edx
      mov bl,[ecx].heads.flag
      and bl,MB_LAST
      or [eax].heads.flag,bl  ;set last if it was last
    .else
      ;make another block
      mov cl,[ecx].heads.flag
      and cl,MB_LAST
      mov ebx,Psiz
      mov [eax].heads.siz,ebx
      mov [eax].heads.flag,0
      add eax,ebx
      mov [eax].heads.magic,'QP'
      mov [eax].heads.flag,MB_FREE
      or [eax].heads.flag,cl  ;set last if needed
      sub edx,Psiz
      sub edx,sizeof heads
      mov [eax].heads.siz,edx
      mov ebx,Pblk
      mov [eax].heads.prev,ebx
    .endif
    mov eax,Pblk
    pop ebp
    ret
  .endif
_2nd:    ;alloc a new block and copy to it
  push Psiz
  call __malloc
  pop ecx
  .if !eax  ;NUL?
    pop ebp
    ret
  .endif
 push eax      ;Preserve...
  mov eax,Pblk
  sub eax,sizeof heads
  mov eax,[eax].heads.siz      ;only copy block size
  .if eax>Psiz
    mov eax,Psiz                ;unless requested size is smaller
  .endif
 mov edi,[esp] ;...for here
  mov esi,Pblk
  mov ecx,eax
  shr ecx,2
  push es
  mov es,cs:_selzero32
  cld
  db 67h  ;use ES:[EDI],DS:[ESI]
  db 66h  ;use ECX
  rep movsd
  pop es
  push Pblk
  call __free
  pop ecx
 pop eax       ;...and here
  pop ebp
  ret
__realloc endp

