data16seg segment

int21h_table_start equ $
int21h_table label byte
  db 9,1ah,1bh,1ch,1fh,25h,2fh,32h,34h,35h,39h,3ah,3bh,3ch,3dh,3fh
  db 40h,41h,43h,47h,48h,49h,4ah,4bh,4eh,4fh,56h,62h
int21h_table_size equ ($-int21h_table_start)
int21h_offset label word
  dw offset x_09h
  dw offset x_1ah
  dw offset x_1bh
  dw offset x_1ch
  dw offset x_1fh
  dw offset x_25h
  dw offset x_2fh
  dw offset x_32h
  dw offset x_34h
  dw offset x_35h
  dw offset x_39h
  dw offset x_3ah
  dw offset x_3bh
  dw offset x_3ch
  dw offset x_3dh
  dw offset x_3fh
  dw offset x_40h
  dw offset x_41h
  dw offset x_43h
  dw offset x_47h
  dw offset x_48h
  dw offset x_49h
  dw offset x_4ah
  dw offset x_4bh
  dw offset x_4eh
  dw offset x_4fh
  dw offset x_56h
  dw offset x_62h
_8kbuffer_seg dw ?       ;segment of 8k RAM used for DOS extensions
_8kbuffer_addr dd 0      ;linear addr

int21h_old_pm label fword
  int21h_old_eip dd ?
  int21h_old_cs dw ?

align 4
_dtaoff dd ?    
_dtaseg dw ?    ;DTA
pspsel dw ?
_dta db 80h dup (?)

data16seg ends

code16seg segment

dos_init_rm proc
  mov ax,200h  ;alloc 8k
  call getRAM

  mov _8kbuffer_seg,bx
  mov wptr _8kbuffer_addr,bx
  shl _8kbuffer_addr,4

  ret
dos_init_rm endp

dos_init_pm proc
  mov ax,204h
  mov bl,21h
  int 31h
  mov int21h_old_eip,edx
  mov int21h_old_cs,cx
  mov ax,205h
  mov bl,21h
  mov cx,cs
  mov edx,offset int21h
  int 31h

;setup DTA
  xor eax,eax
  mov ax,offset _dta
  shl eax,4
  mov _dtaoff,eax
  mov ax,_seldata16
  mov _dtaseg,ax

  call dos_setDTA

  call dos_pspinit

  ret
dos_init_pm endp

dos_pspinit proc  ;setup a selector PSP
  mov ax,0
  mov cx,1
  int 31h  ;alloc a selector (it BETTER work!)
  mov pspsel,ax
  mov bx,ax
  xor ecx,ecx
  mov cx,psp
  shl ecx,4
  mov dx,cx
  shr ecx,16
  mov ax,7
  int 31h  ;set base
  inc al   ;8
  xor cx,cx
  mov dx,100h-1
  int 31h  ;set limit
  ret
dos_pspinit endp

dos_setDTA proc  ;this is used by QX32 only!
  push es
  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0       ;clear SS:SP
  mov bptr[esp+1].callstruct._eax,1ah  ;set DTA
  mov wptr[esp].callstruct._ds,segs16
  mov wptr[esp].callstruct._edx,offset _dta
  mov ax,300h
  mov bx,21h
  xor ecx,ecx
  push ss
  pop es
  mov edi,esp
  int 31h
  add esp,sizeof callstruct
  pop es
  ret
dos_setDTA endp

;-----------------------------------------------------------------------------
; INT 21h Handler (pmode)

int21h proc
  ;ah=func #
  push edi
  push ecx
  push es
  cld
  mov es,cs:_seldata16
  mov di,offset int21h_table
  mov cx,int21h_table_size
  xchg ah,al
  repnz scasb
  xchg ah,al
  jnz bad
  mov di,int21h_table_size
  sub di,cx
  dec di
  shl di,1
  add di,offset int21h_offset
  mov di,es:[di]
  pop es
  pop ecx
  shl edi,16         ;move into high word so we can skip over low word
  xchg edi,[esp]     ;pop edi, store RET addr
  add esp,2          ;skip over low word (it's only a 16bit addr)
  ret                ;jmp to function handler
bad:
  pop es
  pop ecx
  pop edi
  jmp cs:int21h_old_pm  ;cont onto int 21h rmode
int21h endp

;----------------------------------------------------------------------------
; Extended DOS Funcstions

x_09h equ offset x_str

x_1ah proc ;get DTA  (ds:edx)
  push es
  mov es,cs:_seldata16
  mov es:_dtaseg,ds
  mov es:_dtaoff,edx
  pop es
  iretd
x_1ah endp

x_1bh proc  ;get device info (default)
  push es
  pushad
  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0  ;clear SS:SP
  mov bptr[esp+1].callstruct._eax,ah
  mov ax,300h
  mov bx,21h
  xor cx,cx
  push ss
  pop es
  mov edi,esp
  int 31h
  xor eax,eax
  mov ax,[esp].callstruct._ds
  shl eax,4
  xor ebx,ebx
  mov bx,wptr[esp].callstruct._ebx
  add ebx,eax
  mov al,bptr[esp].callstruct._eax
  xor ecx,ecx
  mov cx,wptr[esp].callstruct._ecx
  xor edx,edx
  mov dx,wptr[esp].callstruct._edx
  add esp,sizeof callstruct
  mov bptr[esp].callstruct._eax,al
  mov dptr[esp].callstruct._ebx,ebx
  mov dptr[esp].callstruct._ecx,ecx
  mov dptr[esp].callstruct._edx,edx
  popad
  pop es
  mov ds,cs:_seldata32  ;this will stay so that DS:EBX will pt to rmode
  iretd
x_1bh endp

x_1ch proc  ;get device info (DL)
  push es
  pushad
  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0  ;clear SS:SP
  mov bptr[esp+1].callstruct._eax,ah
  mov bptr[esp].callstruct._edx,dl
  mov ax,300h
  mov bx,21h
  xor cx,cx
  push ss
  pop es
  mov edi,esp
  int 31h
  xor eax,eax
  mov ax,[esp].callstruct._ds
  shl eax,4
  xor ebx,ebx
  mov bx,wptr[esp].callstruct._ebx
  add ebx,eax
  mov al,bptr[esp].callstruct._eax
  xor ecx,ecx
  mov cx,wptr[esp].callstruct._ecx
  xor edx,edx
  mov dx,wptr[esp].callstruct._edx
  add esp,sizeof callstruct
  mov bptr[esp].callstruct._eax,al
  .if al==0ffh
    popad
    pop es
    or bptr[esp+8],1
    iretd
  .endif
  mov dptr[esp].callstruct._ebx,ebx
  mov dptr[esp].callstruct._ecx,ecx
  mov dptr[esp].callstruct._edx,edx
  popad
  pop es
  mov ds,cs:_seldata32  ;this will stay so that DS:EBX will pt to rmode
  iretd
x_1ch endp

x_1fh proc  ;get drive block info (default)
  push es
  pushad
  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0  ;clear SS:SP
  mov bptr[esp+1].callstruct._eax,ah
  mov ax,300h
  mov bx,21h
  xor cx,cx
  push ss
  pop es
  mov edi,esp
  int 31h
  xor eax,eax
  mov ax,[esp].callstruct._ds
  shl eax,4
  xor ebx,ebx
  mov bx,wptr[esp].callstruct._ebx
  add ebx,eax
  mov al,bptr[esp].callstruct._eax
  add esp,sizeof callstruct
  mov bptr[esp].callstruct._eax,al
  .if al==0ffh
    popad
    pop es
    or bptr[esp+8],1
    iretd
  .endif
  mov dptr[esp].callstruct._ebx,ebx
  popad
  pop es
  mov ds,cs:_seldata32  ;this will stay so that DS:EBX will pt to rmode
  iretd
x_1fh endp

x_25h proc  ;set int vektor
  pushad
  mov bl,al
  mov ax,205h
  mov cx,ds
  int 31h
  popad
  .if carry?
    or bptr[esp+8],1
    iretd
  .endif
  and bptr[esp+8],0feh
  iretd
x_25h endp

x_2fh proc  ;set DTA
  push ds
  mov ds,cs:_seldata16
  mov es,_dtaseg
  mov ebx,_dtaoff
  pop ds
  iretd
x_2fh endp

x_32h proc  ;get drive info block (DL)
  push es
  pushad
  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0  ;clear SS:SP
  mov bptr[esp+1].callstruct._eax,ah
  mov bptr[esp].callstruct._edx,dl
  mov ax,300h
  mov bx,21h
  xor cx,cx
  push ss
  pop es
  mov edi,esp
  int 31h
  xor eax,eax
  mov ax,[esp].callstruct._ds
  shl eax,4
  xor ebx,ebx
  mov bx,wptr[esp].callstruct._ebx
  add ebx,eax
  mov al,bptr[esp].callstruct._eax
  add esp,sizeof callstruct
  mov bptr[esp].callstruct._eax,al
  .if al==0ffh
    popad
    pop es
    or bptr[esp+8],1
    iretd
  .endif
  mov dptr[esp].callstruct._ebx,ebx
  popad
  pop es
  mov ds,cs:_seldata32  ;this will stay so that DS:EBX will pt to rmode
  iretd
x_32h endp

x_34h proc  ;get addr of InDOS flag
  pushad
  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0  ;clear SS:SP
  mov bptr[esp+1].callstruct._eax,ah
  mov ax,300h
  mov bx,21h
  xor cx,cx
  push ss
  pop es
  mov edi,esp
  int 31h
  xor eax,eax
  mov ax,[esp].callstruct._es
  shl eax,4
  xor ebx,ebx
  mov bx,wptr[esp].callstruct._ebx
  add ebx,eax
  add esp,sizeof callstruct
  mov dptr[esp].callstruct._ebx,ebx
  popad
  mov es,cs:_seldata32  ;this will stay so that DS:EBX will pt to rmode
  iretd
x_34h endp

x_35h proc  ;get int vektor
  pushad
  mov bl,al
  mov ax,204h
  int 31h
  mov es,cx
  mov [esp].callstruct._ebx,edx
  popad
  and bptr[esp+8],0feh
  iretd
x_35h endp

x_39h equ offset x_str  ;create dir

x_3ah equ offset x_str  ;remove dir

x_3bh equ offset x_str  ;set dir

x_3ch equ offset x_strAX  ;creat file

x_3dh proc  ;open file
  ;open file
  ; DS:EDX = filename
;preserve regs
  pushad
  push es
;now we setup a callstruct to use with DPMI func 300h
  push dptr 0  ;SS:SP
  sub esp,6*2  ;es->cs
  push wptr 0  ;flags
  sub esp,8*4  ;edi->eax
  mov wptr[esp].callstruct._eax,ax
  mov es,cs:_selzero32
  mov ax,cs:_8kbuffer_seg
  mov [esp].callstruct._ds,ax
  mov wptr[esp].callstruct._edx,0
  mov esi,edx
  mov edi,cs:_8kbuffer_addr
s1:
  db 67h
  lodsb
  db 67h
  stosb
  or al,al
  jnz s1
  mov edi,esp
  push ss
  pop es
  xor cx,cx
  mov bx,21h
  mov ax,300h
  int 31h
  xor eax,eax
  mov ax,wptr[esp].callstruct._eax
  mov bl,bptr[esp].callstruct._flg
  add esp,32h      ;remove callstruct on stack
  pop es
  mov [esp].callstruct._eax,eax
  mov al,[esp+8*4+8]
  and bl,1
  and al,0feh
  or al,bl
  mov [esp+8*4+8],al
  popad
  iretd
x_3dh endp

x_3fh proc    ;read from file
  push es
  pushad
  sub esp,12  ;reserve room for 3 vars
  mov ebp,esp  
    v1 equ [ebp]         ;[ebp]=max to read
    v2 equ [ebp+4]       ;[ebp+4]=total read  
    v3 equ [ebp+8]       ;[ebp+8]=dest
  push dptr 0  ;SS:SP
  sub esp,6*2
  push wptr 0  ;flags
  sub esp,8*4
  mov wptr[esp].callstruct._ebx,bx
  mov ax,cs:_8kbuffer_seg
  mov [esp].callstruct._ds,ax
  mov wptr[esp].callstruct._edx,0
  mov v1,ecx             ;max to read (or what's left)
  mov v2,dptr 0          ;total read in so far
  mov v3,edx             ;dest
r1:
  mov bptr[esp].callstruct._eax+1,3fh
  mov eax,v1
  or eax,eax
  jz done
  .if eax>8*1024
    mov ax,8*1024
  .endif
  mov wptr[esp].callstruct._ecx,ax
  mov ax,300h
  mov bx,21h
  xor cx,cx
  push ss
  pop es
  mov edi,esp
  int 31h
;  jc crit    ;problem calling INT 21h? What to do? (crash system?)
  test [esp].callstruct._flg,1     ;is carry set?
  jnz bad
  xor ecx,ecx
  mov cx,wptr[esp].callstruct._eax
  or ecx,ecx
  jz done
;copy data from buffer to v3 (dest)
  add v2,ecx
  sub v1,ecx
  push ds
  pop es
  mov ds,cs:_selzero32
  mov esi,cs:_8kbuffer_addr
  mov edi,v3
  add v3,ecx
  mov al,cl
  shr ecx,2
  db 67h
  rep movsd
  and al,03h
  mov cl,al
  db 67h
  rep movsb
  push es
  pop ds
  jmp r1
done:
  mov eax,v2       ;total read in
  add esp,32h+12   ;pop off old callstruct and local vars
  mov [esp].callstruct._eax,eax
  popad
  pop es
  and bptr[esp+8],0feh  ;clear carry flag
  iretd
bad:
  xor eax,eax
  mov ax,wptr[esp].callstruct._eax
  add esp,32h+12
  mov [esp].callstruct._eax,eax    ;give error code
  popad
  pop es
  or bptr[esp+8],1  ;set carry flag
  iretd
x_3fh endp

x_40h proc  ;write to file
  push es
  pushad
  sub esp,12  ;reserve room for 3 vars
    v1 equ [ebp]      ;[ebp]=max to write
    v2 equ [ebp+4]      ;[ebp+4]=total written  
    v3 equ [ebp+8]      ;[ebp+8]=dest   
  mov ebp,esp  
  push dptr 0
  sub esp,6*2
  push wptr 0
  sub esp,8*4
  mov wptr[esp].callstruct._ebx,bx
  mov ax,cs:_8kbuffer_seg
  mov [esp].callstruct._ds,ax
  mov wptr[esp].callstruct._edx,0
  mov v1,ecx        ;max to write (or what's left)
  mov v2,dptr 0     ;total written so far
  mov v3,edx        ;dest
w1:
  mov bptr[esp].callstruct._eax+1,40h
  mov eax,v1
  or eax,eax
  jz done
  .if eax>8*1024
    mov ax,8*1024
  .endif
  mov wptr[esp].callstruct._ecx,ax
  xor ecx,ecx
  mov cx,ax
;copy from v3 (src) to 8kbuffer
  mov es,cs:_selzero32
  mov edi,cs:_8kbuffer_addr
  mov esi,v3
  add v3,ecx
  mov al,cl
  shr ecx,2
  db 67h
  rep movsd
  and al,3
  mov cl,al
  db 67h
  rep movsb
  push es
  pop ds
;call DOS now
  mov ax,300h
  mov bx,21h
  xor cx,cx
  push ss
  pop es
  mov edi,esp
  int 31h
  test [esp].callstruct._flg,1
  jnz bad
  xor eax,eax
  mov ax,wptr[esp].callstruct._eax
  or eax,eax
  jz done
  add v2,eax
  sub v1,eax
  jmp w1
done:
  mov eax,v2       ;total written
  add esp,32h+12
  mov [esp].callstruct._eax,eax
  popad
  pop es
  and bptr[esp+8],0feh  ;clear carry flag
  iretd
bad:
  xor eax,eax
  mov ax,wptr[esp].callstruct._eax
  add esp,32h+12
  mov [esp].callstruct._eax,eax     ;give error code
  popad
  pop es
  or bptr[esp+8],1  ;set carry flag
  iretd
x_40h endp

x_41h equ x_str  ;del file

x_43h equ x_strCXAL00  ;get/set attr

x_47h equ x_getstr   ;get DIR

x_48h proc  ;alloc DOS ram
  ;in : bx = paras
  ;out: eax = sel (eax = error code ebx=max paras)
  pushad
  mov ax,100h
  xor ecx,ecx
  int 31h
  mov cx,ax
  mov [esp].callstruct._eax,ecx
  .if carry?
    mov cx,bx
    mov [esp].callstruct._ebx,ecx
    popad
    or bptr[esp+8],1
    iretd
  .endif
  popad
  and bptr[esp+8],0feh
  iretd
x_48h endp

x_49h proc  ;free DOS mem
  pushad
  mov ax,100h
  mov bx,es
  int 31h
  .if carry?
    xor ebx,ebx
    mov bx,ax
    mov [esp].callstruct._eax,ebx
    popad
    or bptr[esp+8],1
    iretd
  .endif
  xor ax,ax
  mov es,ax
  popad
  and bptr[esp+8],0feh
  iretd
x_49h endp

x_4ah proc  ;resize DOS ram
  ;in : bx = paras es=sel
  ;out: eax = sel (eax = error code ebx=max paras)
  pushad
  mov ax,102h
  mov dx,es
  int 31h
  .if carry?
    xor ecx,ecx
    mov cx,bx
    mov [esp].callstruct._ebx,ecx
    popad
    or bptr[esp+8],1
    iretd
  .endif
  popad
  and bptr[esp+8],0feh
  iretd
x_4ah endp

x_4bh proc  ;EXECUTE AND LOAD PROGRAM !!!
  .if al
    jmp cs:int21h_old_pm     ;if it's not 4b00h then cont on to DOS
  .endif
;DS:EDX = path name
;ES:EBX = para block
  push ds
  push es
  push fs
  pushad

  push es
  pop fs

  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0      ;clear SS:SP
  mov wptr[esp].callstruct._eax,ax

  mov [esp].callstruct._fs,es     ;preserve here!
  mov [esp].callstruct._esi,ebx   ; " !

  mov ax,ds
  mov es,ax
  mov edi,edx
  mov cx,0ffffh
  xor al,al
  cld
  repnz scasb
  not cx  ;CX=length to print  (including 0)
  mov wptr[esp].callstruct._ebx,cx ;para block will come right after the path

  mov es,cs:_selzero32
  mov edi,cs:_8kbuffer_addr
  mov esi,edx
  rep movsb

  mov ds,[esp].callstruct._fs    ;get ES
  mov edi,ebx
  mov es,[edi+4]   ;get enviro sel
  mov edi,[edi]    ;get enviro off

;search for double 0
  mov cx,0ffffh
  xor al,al
cont:
  repnz scasb
  cmp bptr es:[edi],0
  .if !zero?
    inc edi
    dec cx
    jz fail1   ;too much in enviro
    jmp cont
  .endif
  dec cx  ;include last zero!
  not cx  ;CX=length to print  (including 0)
  ;CX = # bytes needed for enviro
  .if  cx >= 32*1024
fail1:
    add esp,sizeof callstruct
    popad
    pop fs
    pop es
    pop ds
    iretd
  .endif
  xor ebx,ebx
  mov bx,cx
  mov [esp].callstruct._ecx,ebx   ;preserve CX
  add bx,128  ;Max size for command tail
  mov ah,48h
  add bx,0fh
  shr bx,4
  int 21h
  jc fail1
  ;BX=segment for segment
  mov es,cs:_seldata32
  mov edi,[esp].callstruct._ecx
  mov cx,di
  add edi,cs:_8kbuffer_addr
  mov ax,cs:_8kbuffer_seg
  mov es:[edi],bx   ;set enviro segment
  mov es:[edi+2],cx ;set command tail offset
  mov es:[edi+4],ax ;set command tail segment
  mov dptr es:[edi+6],0  ;set FCB1
  mov dptr es:[edi+10],0 ;set FCB2
  mov cx,wptr[esp].callstruct._ecx   ;size of enviro
  mov edx,[esp].callstruct._esi
  mov ds,fs:[edx+4]  ;get enviro sel
  mov esi,fs:[edx]   ;get enviro off
  xor edi,edi
  mov di,bx           ;get offset for enviro
  shl edi,4
  db 67h
  rep movsb   ;copy over enviro
  mov ds,fs:[edx+10]  ;get command sel
  mov esi,fs:[edx+6]  ;get command off
  mov cl,[esi]
  .if cl>=80h
    mov al,7fh
    mov cl,7eh
    stosb
  .endif
  rep movsb

  mov ax,cs:_8kbuffer_seg
  mov wptr[esp].callstruct._ds,ax
  mov wptr[esp].callstruct._edx,0     ;DS:DX = 8k buffer
  mov wptr[esp].callstruct._es,ax     ;ES:BX = 8k buffer (after DS:DX) BX already setup
  mov ax,300h
  mov bx,21h
  xor cx,cx
  mov edi,esp
  push ss
  pop es
  int 31h

  xor eax,eax
  mov ax,wptr[esp].callstruct._eax
  mov bl,bptr[esp].callstruct._flg
  add esp,sizeof callstruct
  .if (bl & 1)
    mov [esp].callstruct._eax,eax
    or bptr[esp+8+8*4+6],1
  .else
    and bptr[esp+8+8*4+6],0feh
  .endif
  popad
  pop fs
  pop es
  pop ds
  iretd
x_4bh endp

x_4eh proc ;find first
  pushfd
  db 66h
  push cs
  push dptr offset r1
  jmp x_str
r1:
  .if carry?
    or bptr[esp+8],1
  .else
    and bptr[esp+8],0feh
    call copy_fromDTA  ;copy from Rmode DTA to Pmode DTA
  .endif
  iretd
x_4eh endp

x_4fh proc ;find first
  pushad

  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0      ;clear SS:SP
  mov wptr[esp].callstruct._eax,ax
  mov ax,300h
  mov bx,21h
  xor cx,cx
  mov edi,esp
  push ss
  pop es
  int 31h
  mov bl,bptr[esp].callstruct._flg
  xor eax,eax
  mov ax,wptr[esp].callstruct._eax
  add esp,sizeof callstruct
  .if !zero?
    or bptr[esp+8],1
    mov [esp].callstruct._eax,eax
  .else
    and bptr[esp+8],0feh
    call copy_fromDTA  ;copy from Rmode DTA to Pmode DTA
  .endif
  popad
  iretd
x_4fh endp

x_56h proc  ;rename file
  ;ds:edx = old
  ;es:edi = new
  push ds
  push es
  pushad

  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0      ;clear SS:SP
  mov wptr[esp].callstruct._eax,ax

  push es
  push edi

  mov ax,ds
  mov es,ax
  mov edi,edx
  mov cx,0ffffh
  xor al,al
  cld
  repnz scasb
  not cx  ;CX=length to print  (including 0)
  mov bp,cx   ;save for later

  mov es,cs:_selzero32
  mov edi,cs:_8kbuffer_addr
  mov esi,edx
  rep movsb

  mov esi,edi
  pop edx  ;was edi
  mov es,wptr[esp]

  mov edi,edx
  mov cx,0ffffh
  xor al,al
  cld
  repnz scasb
  not cx  ;CX=length to print  (including 0)

  pop ds
  mov es,cs:_selzero32
  mov edi,esi
  mov esi,edx
  rep movsb

  mov ax,cs:_8kbuffer_seg
  mov wptr[esp].callstruct._ds,ax
  mov wptr[esp].callstruct._edx,0     ;DS:DX = 8k buffer
  mov wptr[esp].callstruct._es,ax
  mov wptr[esp].callstruct._edi,bp    ;ES:DI = 8k buffer (after DS:DX)
  mov ax,300h
  mov bx,21h
  xor cx,cx
  mov edi,esp
  push ss
  pop es
  int 31h

  xor eax,eax
  mov ax,wptr[esp].callstruct._eax
  mov bl,bptr[esp].callstruct._flg
  add esp,sizeof callstruct
  .if (bl & 1)
    mov [esp].callstruct._eax,eax
    or bptr[esp+8+8*4+4],1
  .else
    and bptr[esp+8+8*4+4],0feh
  .endif
  popad
  pop es
  pop ds
  iretd
x_56h endp

x_62h proc
  mov bx,cs:pspsel
  iretd
x_62h endp

x_str proc
;DS:EDX = ASC2Z str
;EAX returned only on error
  push es
  pushad

  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0      ;clear SS:SP
  mov wptr[esp].callstruct._eax,ax
  mov wptr[esp].callstruct._eax,cx

  mov ax,ds
  mov es,ax
  mov edi,edx
  mov cx,0ffffh
  xor al,al
  cld
  repnz scasb
  not cx  ;CX=length to print  (including 0)

  mov es,cs:_selzero32
  mov edi,cs:_8kbuffer_addr
  mov esi,edx
  rep movsb

  mov ax,cs:_8kbuffer_seg
  mov wptr[esp].callstruct._ds,ax
  mov wptr[esp].callstruct._edx,0     ;DS:DX = 8k buffer
  mov ax,300h
  mov bx,21h
  xor cx,cx
  mov edi,esp
  push ss
  pop es
  int 31h

  xor eax,eax
  mov ax,wptr[esp].callstruct._eax
  mov bl,bptr[esp].callstruct._flg
  add esp,sizeof callstruct
  .if (bl & 1)
    mov [esp].callstruct._eax,eax
    or bptr[esp+8+8*4+2],1
  .else
    and bptr[esp+8+8*4+2],0feh
  .endif
  popad
  pop es
  iretd
x_str endp

x_strAX proc
;DS:EDX = ASC2Z str
;EAX always returned
  push es
  pushad

  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0      ;clear SS:SP
  mov wptr[esp].callstruct._eax,ax
  mov wptr[esp].callstruct._eax,cx

  mov ax,ds
  mov es,ax
  mov edi,edx
  mov cx,0ffffh
  xor al,al
  cld
  repnz scasb
  not cx  ;CX=length to print  (including 0)

  mov es,cs:_selzero32
  mov edi,cs:_8kbuffer_addr
  mov esi,edx
  rep movsb

  mov ax,cs:_8kbuffer_seg
  mov wptr[esp].callstruct._ds,ax
  mov wptr[esp].callstruct._edx,0     ;DS:DX = 8k buffer
  mov ax,300h
  mov bx,21h
  xor cx,cx
  mov edi,esp
  push ss
  pop es
  int 31h

  xor eax,eax
  mov ax,wptr[esp].callstruct._eax
  mov bl,bptr[esp].callstruct._flg
  add esp,sizeof callstruct
  mov [esp].callstruct._eax,eax
  .if (bl & 1)
    or bptr[esp+8+8*4+2],1
  .else
    and bptr[esp+8+8*4+2],0feh
  .endif
  popad
  pop es
  iretd
x_strAX endp

x_strCXAL00 proc
;DS:EDX = ASC2Z str
;EAX returned on error
;CX return if AL=0
  push es
  pushad

  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0      ;clear SS:SP
  mov wptr[esp].callstruct._eax,ax
  mov wptr[esp].callstruct._eax,cx

  mov ax,ds
  mov es,ax
  mov edi,edx
  mov cx,0ffffh
  xor al,al
  cld
  repnz scasb
  not cx  ;CX=length to print  (including 0)

  mov es,cs:_selzero32
  mov edi,cs:_8kbuffer_addr
  mov esi,edx
  rep movsb

  mov ax,cs:_8kbuffer_seg
  mov wptr[esp].callstruct._ds,ax
  mov wptr[esp].callstruct._edx,0     ;DS:DX = 8k buffer
  mov ax,300h
  mov bx,21h
  xor cx,cx
  mov edi,esp
  push ss
  pop es
  int 31h

  xor eax,eax
  mov ax,wptr[esp].callstruct._eax
  xor ecx,ecx
  mov cx,wptr[esp].callstruct._ecx
  mov bl,bptr[esp].callstruct._flg
  add esp,sizeof callstruct
  .if (bl & 1)
    mov [esp].callstruct._eax,eax
    or bptr[esp+8+8*4+2],1
  .else
    .if ! bptr[esp].callstruct._eax
      mov [esp].callstruct._ecx,ecx
    .endif
    and bptr[esp+8+8*4+2],0feh
  .endif
  popad
  pop es
  iretd
x_strCXAL00 endp

x_getstr proc
;DS:ESI = buffer for ASC2Z string
;EAX returned only on error
  push es
  pushad

  sub esp,sizeof callstruct
  mov dptr[esp].callstruct._sp,0      ;clear SS:SP
  mov wptr[esp].callstruct._eax,ax
  mov wptr[esp].callstruct._edx,dx

  mov ax,cs:_8kbuffer_seg
  mov wptr[esp].callstruct._ds,ax
  mov wptr[esp].callstruct._esi,0     ;DS:SI = 8k buffer
  mov ax,300h
  mov bx,21h
  xor cx,cx
  mov edi,esp
  push ss
  pop es
  int 31h

  mov es,cs:_selzero32
  mov edi,cs:_8kbuffer_addr
  mov cx,0ffffh
  xor al,al
  cld
  repnz scasb
  not cx  ;CX=length to print  (including 0)

  mov ax,ds         ;-+
  mov bx,es         ; |
  mov ds,bx         ; |
  mov es,ax         ;Swap DS/ES

  mov ds,cs:_selzero32
  mov edi,esi
  mov esi,cs:_8kbuffer_addr
  rep movsb

  xor eax,eax
  mov ax,wptr[esp].callstruct._eax
  mov bl,bptr[esp].callstruct._flg
  add esp,sizeof callstruct
  .if (bl & 1)
    mov [esp].callstruct._eax,eax
    or bptr[esp+8+8*4+2],1
  .else
    and bptr[esp+8+8*4+2],0feh
  .endif
  popad
  pop es
  iretd
x_getstr endp

;copies from rmode DTA to Pmode DTA
copy_fromDTA proc uses es ds ecx edi esi  
  ;must preserve ALL regs
  mov ds,cs:_seldata16
  mov esi,offset _dta
  mov es,cs:_dtaseg
  mov edi,cs:_dtaoff
  cld
  mov cx,80h/4
  rep movsd
  ret
copy_fromDTA endp

code16seg ends

