data16seg segment

xms_base dd ?    ;the start of our XMS RAM we have alloc [RAW/XMS/VCPI]
xms_size dd ?    ;the size of our XMS RAM                [RAW/XMS/VCPI]

xms_call dd ?    ;seg:off to call XMS driver             [XMS]
xms_emb dw ?     ;our EMB handle alloc'ed from XMS       [XMS]

msg_xms_low db 'Insufficent XMS memory found!',13,10,'$'
msg_xms_lock db 'Unable to lock XMS memory block!',13,10,'$'

data16seg ends

code16seg segment

xms_detect proc
  mov ax,4300h
  int 2fh
  cmp al,80h
  .if al==80h
    mov al,1
    ret
  .endif
  xor al,al
  ret
xms_detect endp

XMS_init proc
  mov mode,MODE_XMS
;call a non-desctructive DOS func (to avoid bugs in some XMS drivers)
  mov ah,2ch
  int 21h                              ; get time (but this is ignored)
  mov ax,4310h
  int 2fh                              ; get XMS entry-point
  mov wptr [xms_call+2],es
  mov wptr [xms_call],bx
  push cs                              ;-+
  pop es                               ;restore ES

;enable A20 thru XMS driver
  mov ah,3
  call [xms_call]                      ; global enable A20
  cmp ax,1
  jz x1
  mov dx,offset msg_a20
  jmp exit16error
x1:
  mov ah,8
  call [xms_call]                      ; query free extended memory
  ;ax=RAM free (1k blocks)  (max=64 MBs)
  mov ebx,ram_max
  shr ebx,10  ;convert bytes to Ks
  .if ebx>=64*1024  ;64MBs?
    mov ax,0ffffh
  .elseif ax>bx
    mov ax,bx
  .endif
  xor edx,edx
  mov dx,ax
  shl edx,10                           ;-+   ;*1k
  mov xms_size,edx                     ; |
  shr edx,10                           ;find total size of block
  mov ah,9
  call [xms_call]                      ; alloc EMB
  .if ax!=1
    mov dx,offset msg_xms_low
    jmp exit16error
  .endif

  mov inited,1                         ;after this point xms_uninit should be
                                       ;called on fatal errors

  mov xms_emb,dx
  mov ah,0ch
  call [xms_call]                      ; lock EMB
  cmp ax,1
  jz x4
  mov dx,offset msg_xms_lock
  jmp exit16error
x4:
  shl edx,16
  mov dx,bx
  mov xms_base,edx
  ret
xms_init endp

xms_uninit proc
; in : ds=segs16  es=0
  mov ah,0dh
  mov dx,xms_emb
  call [xms_call]                      ; unlock RAM
  mov ah,0ah
  mov dx,xms_emb
  call [xms_call]                      ; free RAM used
  ret
xms_uninit endp

code16seg ends

